/*
 * Decompiled with CFR 0.152.
 */
package org.jblas.util;

import org.jblas.ComplexDouble;
import org.jblas.ComplexDoubleMatrix;
import org.jblas.DoubleMatrix;
import org.jblas.Eigen;
import org.jblas.NativeBlas;
import org.jblas.Singular;
import org.jblas.util.Logger;

public class SanityChecks {
    public static int checksFailed;

    public static void check(String message, boolean condition) {
        System.out.print(message + "... ");
        if (condition) {
            System.out.println("ok");
        } else {
            System.out.println("failed");
            ++checksFailed;
        }
    }

    public static void checkVectorAddition() {
        DoubleMatrix x = new DoubleMatrix(3, 1, 1.0, 2.0, 3.0);
        DoubleMatrix y = new DoubleMatrix(3, 1, 4.0, 5.0, 6.0);
        DoubleMatrix z = new DoubleMatrix(3, 1, 5.0, 7.0, 9.0);
        SanityChecks.check("checking vector addition", x.add(y).equals(z));
    }

    public static void checkMatrixMultiplication() {
        DoubleMatrix A = new DoubleMatrix(new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}});
        DoubleMatrix E = new DoubleMatrix(new double[][]{{0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}});
        DoubleMatrix B = new DoubleMatrix(new double[][]{{3.0, 2.0, 1.0}, {6.0, 5.0, 4.0}, {9.0, 8.0, 7.0}});
        SanityChecks.check("checking matrix multiplication", A.mmul(E).equals(B));
    }

    public static void checkXerbla() {
        double[] x = new double[9];
        System.out.println("Check whether we're catching XERBLA errors. If you see something like \"** On entry to DGEMM  parameter number  4 had an illegal value\", it didn't work!");
        try {
            NativeBlas.dgemm('N', 'N', 3, -1, 3, 1.0, x, 0, 3, x, 0, 3, 0.0, x, 0, 3);
        }
        catch (IllegalArgumentException e) {
            SanityChecks.check("checking XERBLA", e.getMessage().contains("XERBLA"));
            return;
        }
        assert (false);
    }

    public static void checkEigenvalues() {
        DoubleMatrix A = new DoubleMatrix(new double[][]{{3.0, 2.0, 0.0}, {2.0, 3.0, 2.0}, {0.0, 2.0, 3.0}});
        DoubleMatrix E = new DoubleMatrix(3, 1);
        NativeBlas.dsyev('N', 'U', 3, A.data, 0, 3, E.data, 0);
        SanityChecks.check("checking existence of dsyev...", true);
    }

    public static void checkSVD() {
        double[][] data = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 9.0}, {-1.0, -2.0, -3.0}};
        DoubleMatrix A = new DoubleMatrix(data);
        DoubleMatrix[] USV = Singular.sparseSVD(A);
        System.out.println(USV[0].toString());
        System.out.println(USV[1].toString());
        System.out.println(USV[2].toString());
        System.out.println(Singular.SVDValues(A));
        SanityChecks.check("checking existence of dgesvd...", true);
    }

    public static void checkGeneralizedEigenvalues() {
        DoubleMatrix A = new DoubleMatrix(3, 3, 2.0, 1.0, 0.0, 1.0, 2.0, 1.0, 0.0, 1.0, 2.0);
        DoubleMatrix B = new DoubleMatrix(3, 3, 4.0, 2.0, 1.0, 2.0, 4.0, 2.0, 1.0, 2.0, 4.0);
        DoubleMatrix[] LA = Eigen.symmetricGeneralizedEigenvectors(A, B);
        SanityChecks.check("checkign existence of gsyevd (generalized eigenvalues)...", true);
    }

    public static void checkComplexReturnValues() {
        double[] data = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        ComplexDoubleMatrix A = new ComplexDoubleMatrix(data);
        ComplexDouble z = A.dotu(A);
        System.out.print("Checking complex return values... ");
        System.out.println("(z = " + z.toString() + ")");
    }

    public static void main(String[] args) {
        Logger.getLogger().setLevel(2);
        for (String arg : args) {
            if (!arg.equals("--debug")) continue;
            Logger.getLogger().setLevel(1);
        }
        SanityChecks.checkVectorAddition();
        SanityChecks.checkMatrixMultiplication();
        SanityChecks.checkEigenvalues();
        SanityChecks.checkSVD();
        SanityChecks.checkComplexReturnValues();
        SanityChecks.checkXerbla();
        SanityChecks.printSummary();
    }

    private static void printSummary() {
        if (checksFailed == 0) {
            System.out.println("Sanity checks passed.");
        } else {
            System.out.println("Sainty checks FAILED!");
        }
    }
}

