(ns schema.extensions.field
  (:require [schema.core :as s]
            [schema.extensions.endpoint :refer [endpoint]]
            [schema.extensions.derived :refer [derived defaulting auto-defaulting massaging optional]]
            [schema.extensions.util :refer [field-update]]))

(def field-meta schema.extensions.util/field-meta)

;; Some things reproduced from ring.swagger.schema

(defn field
  "Attaches meta-data to a schema under :json-schema key. If the
   schema is of type which cannot have meta-data (e.g. Java Classes)
   schema is wrapped first into s/both Schema."
  [schema & args]
  (let [mapargs (apply hash-map args)]
    (cond-> schema
            true (field-update mapargs)
            (some? (:derived mapargs)) (derived (:derived mapargs))
            (some? (:default mapargs)) (defaulting (:default mapargs))
            (some? (:optional mapargs)) optional
            (some? (:massage mapargs)) (massaging (:massage mapargs))
            (some? (:autodef mapargs)) auto-defaulting
            (some? (:endpoint mapargs)) (endpoint :singular (:singular mapargs)))))

(defn describe
  "Attach description and possibly other meta-data to a schema."
  [schema desc & args]
  (apply field schema :description desc args))