(ns schema.extensions.endpoint
  (:require [clojure.string :as string]
            [schema.core :as s]
            [schema.extensions.util :refer [field-meta]]))


;;; Endpoint (schema elements)
;;; a schema that has endpoints

(defn endpoint
  "A value that must satisfy schema, and can be add."
  [singular]
  {:_endpoint {:singular singular}})

(defn endpoint? [schema]
  (-> schema field-meta :_endpoint some?))

(defn endpoint-singular [schema]
  (-> schema field-meta :_endpoint :singular))

(defn get-elem [v id]
  (->> v
       (filter #(= (:id %) id))
        first))

(defn root-path [path]
  (str "/" path))

(defn db-path [path]
  (string/replace path #"/" "."))
