(ns schema.extensions.timestamp
  (:require [schema.core :as s]
            [#?(:clj clj-time.core
                :cljs cljs-time.core) :as t]
            [#?(:clj clj-time.coerce
                :cljs cljs-time.coerce) :as c]
            [schema.extensions.util :refer [PosInt]]
            [schema.extensions.field :refer [describe]]))

;; Millisecond timestamp

(defn ms->date-time [ms] (-> ms c/from-long))

(defn date-time->ms [dt] (c/to-long dt))

(defn valid-ms-timestamp? [ms]
  (try (t/after? (ms->date-time ms) (t/date-time 2000 1 1))
       (catch #?(:clj Exception :cljs js/Error) e false)))

(s/defschema MsTimestamp
  (describe (s/constrained s/Int valid-ms-timestamp? 'vald-ms-timestamp?)
            "A millisecond since epoch timestamp"))
