(ns schema.extensions.timestamp
  (:require [schema.core :as s]
            #?@(:clj [[clj-time.core :as t]
                      [clj-time.coerce :as c]])
            [schema.extensions.util :refer [PosInt]]
            [schema.extensions.field :refer [describe]]))

;; Millisecond timestamp

(def ^:private ms-2000-01-01 949388400000)

(defn ms->date-time [ms]
  #?(:clj (-> ms c/from-long)
     :cljs (js/Date. ms)))

(defn date-time->ms [dt]
  #?(:clj (c/to-long dt)
     :cljs (.getTime dt)))

(defn ms-timestamp []
  #?(:clj (System/currentTimeMillis)
     :cljs (js/Date.now)))

(defn add-months [ms n]
  (+ ms (-> n
            (* 30)
            (* 24)
            (* 60)
            (* 60)
            (* 1000))))

(defn valid-ms-timestamp? [ms]
  (> ms ms-2000-01-01))

(s/defschema MsTimestamp
  (describe (s/constrained s/Int valid-ms-timestamp? 'vald-ms-timestamp?)
            "A millisecond since epoch timestamp"))
