(ns jarvis.plugins.rally
  (:require [jarvis.rally.helpers :as helper]
            [jarvis.rally.api :as api]
            [clojure.string :as s]))

(declare get-info)

(defn ^{:description "rally <formattedID> - Returns the details"
        :command "rally"
        :author "Jonathan Chauncey Matt Farrar"
        :plugin true}
  rally [message]
  (if-let [[artifact-type artifact] (helper/get-artifact message)]
    (get-info artifact-type artifact)
    "Dreadfully sorry, I was unable to find an artifact with that Formatted ID."))

(defn get-info [artifact-type artifact]
  (str
    "\n\t"
    "Formatted ID: " (get artifact "FormattedID") "\n\t"
    "Name: " (get artifact "Name") "\n\t"
    "Owner: " (get-in artifact ["Owner" "_refObjectName"]) "\n\t"
    "Project: " (get-in artifact ["Project" "_refObjectName"]) "\n\t"
    "ScheduleState: " (get artifact "ScheduleState") "\n\t"
    "Description: " (get artifact "Description") "\n\t"
    "Detail Link: " (helper/detail-url artifact-type (get artifact "ObjectID"))))
