/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.authenticator;

import io.dropwizard.auth.LdapDenyAll;
import io.dropwizard.auth.LdapPermitAll;
import io.dropwizard.auth.LdapRolesAllowed;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.AnnotatedMethod;

public class LdapRolesAllowedDynamicFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext configuration) {
        AnnotatedMethod am = new AnnotatedMethod(resourceInfo.getResourceMethod());
        if (am.isAnnotationPresent(LdapDenyAll.class)) {
            configuration.register((Object)new RolesAllowedRequestFilter());
            return;
        }
        LdapRolesAllowed ra = (LdapRolesAllowed)am.getAnnotation(LdapRolesAllowed.class);
        if (ra != null) {
            configuration.register((Object)new RolesAllowedRequestFilter(ra.value()));
            return;
        }
        if (am.isAnnotationPresent(LdapPermitAll.class)) {
            return;
        }
        ra = resourceInfo.getResourceClass().getAnnotation(LdapRolesAllowed.class);
        if (ra != null) {
            configuration.register((Object)new RolesAllowedRequestFilter(ra.value()));
        }
    }

    @Priority(value=2000)
    private static class RolesAllowedRequestFilter
    implements ContainerRequestFilter {
        private final boolean denyAll;
        private final String[] rolesAllowed;

        RolesAllowedRequestFilter() {
            this.denyAll = true;
            this.rolesAllowed = null;
        }

        RolesAllowedRequestFilter(String[] rolesAllowed) {
            this.denyAll = false;
            this.rolesAllowed = rolesAllowed != null ? rolesAllowed : new String[]{};
        }

        private static boolean isAuthenticated(ContainerRequestContext requestContext) {
            return requestContext.getSecurityContext().getUserPrincipal() != null;
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            if (!this.denyAll) {
                if (this.rolesAllowed.length > 0 && !RolesAllowedRequestFilter.isAuthenticated(requestContext)) {
                    throw new ForbiddenException(LocalizationMessages.USER_NOT_AUTHORIZED());
                }
                for (String role : this.rolesAllowed) {
                    if (!requestContext.getSecurityContext().isUserInRole(role)) continue;
                    return;
                }
            }
            throw new ForbiddenException(LocalizationMessages.USER_NOT_AUTHORIZED());
        }
    }
}

