/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.authenticator;

import com.yammer.dropwizard.authenticator.LdapAuthenticator;
import com.yammer.dropwizard.authenticator.LdapCanAuthenticate;
import com.yammer.dropwizard.authenticator.LdapConfiguration;
import com.yammer.dropwizard.authenticator.LdapRolesAllowedDynamicFeature;
import com.yammer.dropwizard.authenticator.LdapUser;
import com.yammer.dropwizard.authenticator.ResourceAuthenticator;
import com.yammer.dropwizard.authenticator.UserResourceAuthenticator;
import com.yammer.dropwizard.authenticator.healthchecks.LdapHealthCheck;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.CachingAuthenticator;
import io.dropwizard.auth.LdapAuthDynamicFeature;
import io.dropwizard.auth.LdapAuthValueFactoryProvider;
import io.dropwizard.auth.basic.BasicCredentialAuthFilter;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import javax.ws.rs.container.ContainerRequestFilter;

public abstract class LdapAuthenticatorBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private LdapCanAuthenticate ldapContext;

    public abstract LdapConfiguration getConfiguration(T var1);

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) {
        LdapConfiguration ldapConfiguration = this.getConfiguration(configuration);
        CachingAuthenticator ldapAuthenticator = new CachingAuthenticator(environment.metrics(), (Authenticator)new UserResourceAuthenticator(new LdapAuthenticator(ldapConfiguration)), ldapConfiguration.getCachePolicy());
        environment.jersey().register((Object)new LdapAuthDynamicFeature((ContainerRequestFilter)new BasicCredentialAuthFilter.Builder().setAuthenticator((Authenticator)ldapAuthenticator).setAuthorizer((user, role) -> user.getRoles().contains(role)).setRealm("realm").buildAuthFilter()));
        environment.jersey().register(LdapRolesAllowedDynamicFeature.class);
        environment.jersey().register(new LdapAuthValueFactoryProvider.Binder<LdapUser>(LdapUser.class));
        this.ldapContext = new LdapCanAuthenticate(ldapConfiguration);
        environment.healthChecks().register("ldap", new LdapHealthCheck<LdapUser>(new ResourceAuthenticator(this.ldapContext)));
    }

    public LdapCanAuthenticate getLdapContext() {
        return this.ldapContext;
    }
}

