/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.ranger.finder;

import com.flipkart.ranger.finder.RandomServiceNodeSelector;
import com.flipkart.ranger.finder.Service;
import com.flipkart.ranger.finder.ServiceFinder;
import com.flipkart.ranger.model.Deserializer;
import com.flipkart.ranger.model.ServiceNodeSelector;
import com.flipkart.ranger.model.ServiceRegistry;
import com.flipkart.ranger.model.ShardSelector;
import com.google.common.base.Preconditions;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseServiceFinderBuilder<T, RegistryType extends ServiceRegistry<T>, FinderType extends ServiceFinder<T, RegistryType>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseServiceFinderBuilder.class);
    private String namespace;
    private String serviceName;
    private CuratorFramework curatorFramework;
    private String connectionString;
    private int nodeRefreshIntervalMs;
    private boolean disableWatchers;
    private Deserializer<T> deserializer;
    private ShardSelector<T, RegistryType> shardSelector;
    private ServiceNodeSelector<T> nodeSelector = new RandomServiceNodeSelector();

    public BaseServiceFinderBuilder<T, RegistryType, FinderType> withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public BaseServiceFinderBuilder<T, RegistryType, FinderType> withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public BaseServiceFinderBuilder<T, RegistryType, FinderType> withCuratorFramework(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
        return this;
    }

    public BaseServiceFinderBuilder<T, RegistryType, FinderType> withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public BaseServiceFinderBuilder<T, RegistryType, FinderType> withDeserializer(Deserializer<T> deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public BaseServiceFinderBuilder<T, RegistryType, FinderType> withShardSelector(ShardSelector<T, RegistryType> shardSelector) {
        this.shardSelector = shardSelector;
        return this;
    }

    public BaseServiceFinderBuilder<T, RegistryType, FinderType> withNodeSelector(ServiceNodeSelector<T> nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    public BaseServiceFinderBuilder<T, RegistryType, FinderType> withNodeRefreshIntervalMs(int nodeRefreshIntervalMs) {
        this.nodeRefreshIntervalMs = nodeRefreshIntervalMs;
        return this;
    }

    public BaseServiceFinderBuilder<T, RegistryType, FinderType> withDisableWatchers() {
        this.disableWatchers = true;
        return this;
    }

    public BaseServiceFinderBuilder<T, RegistryType, FinderType> withDisableWatchers(boolean disableWatchers) {
        this.disableWatchers = disableWatchers;
        return this;
    }

    public FinderType build() {
        Preconditions.checkNotNull(this.namespace);
        Preconditions.checkNotNull(this.serviceName);
        Preconditions.checkNotNull(this.deserializer);
        if (null == this.curatorFramework) {
            Preconditions.checkNotNull(this.connectionString);
            this.curatorFramework = CuratorFrameworkFactory.builder().namespace(this.namespace).connectString(this.connectionString).retryPolicy(new ExponentialBackoffRetry(1000, 100)).build();
            this.curatorFramework.start();
        }
        if (this.nodeRefreshIntervalMs < 1000) {
            LOGGER.warn("Node refresh interval for {} is too low: {} ms. Has been upgraded to 1000ms ", (Object)this.serviceName, (Object)this.nodeRefreshIntervalMs);
            this.nodeRefreshIntervalMs = 1000;
        }
        Service service = new Service(this.curatorFramework, this.namespace, this.serviceName);
        return this.buildFinder(service, this.deserializer, this.shardSelector, this.nodeSelector, this.nodeRefreshIntervalMs, this.disableWatchers);
    }

    protected abstract FinderType buildFinder(Service var1, Deserializer<T> var2, ShardSelector<T, RegistryType> var3, ServiceNodeSelector<T> var4, int var5, boolean var6);
}

