/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.ranger.healthservice.monitor;

import com.flipkart.ranger.healthcheck.HealthcheckStatus;
import com.flipkart.ranger.healthservice.monitor.Monitor;
import java.io.File;

public class Monitors {
    private Monitors() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static Monitor<HealthcheckStatus> fileExistanceCheckMonitor(final String filePath) {
        return new Monitor<HealthcheckStatus>(){

            @Override
            public HealthcheckStatus monitor() {
                File file = new File(filePath);
                if (file.exists()) {
                    return HealthcheckStatus.healthy;
                }
                return HealthcheckStatus.unhealthy;
            }

            @Override
            public boolean isDisabled() {
                return false;
            }
        };
    }

    public static Monitor<HealthcheckStatus> defaultHealthyMonitor() {
        return new Monitor<HealthcheckStatus>(){

            @Override
            public HealthcheckStatus monitor() {
                return HealthcheckStatus.healthy;
            }

            @Override
            public boolean isDisabled() {
                return false;
            }
        };
    }
}

