/*
 * Decompiled with CFR 0.152.
 */
package com.raven.rundeck.ranger.http;

import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.plugins.Plugin;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.plugins.step.PluginStepContext;
import com.dtolabs.rundeck.plugins.step.StepPlugin;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.dtolabs.rundeck.plugins.util.PropertyBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.ranger.model.ServiceNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.raven.rundeck.ranger.http.ServiceDiscoveryClient;
import com.raven.rundeck.ranger.http.ShardInfo;
import java.util.Map;
import java.util.Optional;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;

@Plugin(name="com.raven.rundeck.ranger.http.HttpClient", service="WorkflowStep")
public class HttpClient
implements StepPlugin,
Describable {
    private static final Log log = LogFactory.getLog(HttpClient.class);
    private ServiceDiscoveryClient serviceDiscoveryClient;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private CuratorFramework curatorFramework;
    private static OkHttpClient httpClient;

    public Description getDescription() {
        return DescriptionBuilder.builder().name("com.raven.rundeck.ranger.http.HttpClient").title("Ranger Http Call").description("Makes a HTTP call using ranger service discovery").property(PropertyBuilder.builder().string("zkConnectionString").title("Zookeeper Connection").description("Zookeeper Connection String").required(true).build()).property(PropertyBuilder.builder().string("namespace").title("Namespace").description("Namespace for service discovery").required(true).build()).property(PropertyBuilder.builder().string("service").title("Service").description("Name of the service").required(true).build()).property(PropertyBuilder.builder().string("environment").title("Environment").description("Service discovery environment").required(true).build()).property(PropertyBuilder.builder().select("method").title("Method").description("HTTP Method").required(true).defaultValue("GET").values(new String[]{"GET", "POST", "PUT", "DELETE"}).build()).property(PropertyBuilder.builder().booleanType("secured").title("Secured").description("Secured Service").required(false).defaultValue("false").build()).property(PropertyBuilder.builder().string("uri").title("URI").description("URI").required(true).defaultValue("/").build()).property(PropertyBuilder.builder().string("payload").title("Request Payload").description("Payload that needs to be sent with request").required(false).defaultValue(null).renderingAsTextarea().build()).property(PropertyBuilder.builder().string("user").title("User Name").description("User Name").required(false).defaultValue(null).build()).property(PropertyBuilder.builder().string("password").title("Password").description("Password").required(false).defaultValue(null).renderingAsPassword().build()).property(PropertyBuilder.builder().string("authorization").title("Authorization Token").description("Authorization Token/Header that will be sent (Specify with prefix)").required(false).defaultValue(null).renderingAsPassword().build()).property(PropertyBuilder.builder().string("acceptHeader").title("Accept Header").description("Accept Header, Defaulted to application/json").required(false).defaultValue("application/json").build()).property(PropertyBuilder.builder().string("contentTypeHeader").title("Content Type Header").description("Content Type Header, Defaulted to application/json").required(false).defaultValue("application/json").build()).build();
    }

    public void executeStep(PluginStepContext pluginStepContext, Map<String, Object> map) throws StepException {
        try {
            log.info("Initializing ranger HTTP call");
            this.init(map);
            log.info("Initialized ranger HTTP call");
            log.info("Executing ranger HTTP call");
            this.execute(map);
            log.info("Completed executing ranger HTTP call");
        }
        catch (Exception e) {
            log.error("Error executing HTTP ranger call", e);
            throw new StepException((Throwable)e, (FailureReason)StepFailureReason.ConfigurationFailure);
        }
    }

    private synchronized void init(Map<String, Object> map) throws Exception {
        String namespace = String.valueOf(map.get("namespace"));
        String service = String.valueOf(map.get("service"));
        String environment = String.valueOf(map.get("environment"));
        String zkConnectionString = String.valueOf(map.get("zkConnectionString"));
        log.info("Ranger Call configuration [ ZK Connection String: " + zkConnectionString + " | Namespace: " + namespace + " | Service: " + service + " | Environment: " + environment);
        if (this.curatorFramework == null) {
            this.curatorFramework = CuratorFrameworkFactory.builder().namespace(namespace).zk34CompatibilityMode(true).connectString(zkConnectionString).retryPolicy(new RetryNTimes(5000, 1000)).build();
            this.curatorFramework.start();
        }
        if (httpClient == null) {
            String user = String.valueOf(map.get("user"));
            String password = String.valueOf(map.get("password"));
            String authorization = String.valueOf(map.get("authorization"));
            httpClient = !Strings.isNullOrEmpty(user) & Strings.isNullOrEmpty(authorization) ? new OkHttpClient.Builder().followRedirects(true).hostnameVerifier((s2, sslSession) -> true).authenticator((route, response) -> {
                String credentials = Credentials.basic(user, password);
                return response.request().newBuilder().addHeader("Authorization", credentials).build();
            }).build() : (!Strings.isNullOrEmpty(authorization) ? new OkHttpClient.Builder().followRedirects(true).hostnameVerifier((s2, sslSession) -> true).authenticator((route, response) -> response.request().newBuilder().addHeader("Authorization", authorization).build()).build() : new OkHttpClient.Builder().followRedirects(true).hostnameVerifier((s2, sslSession) -> true).build());
        }
        this.serviceDiscoveryClient = ServiceDiscoveryClient.fromCurator().curator(this.curatorFramework).disableWatchers(true).namespace(namespace).environment(environment).serviceName(service).refreshTimeMs(10000).objectMapper(OBJECT_MAPPER).build();
        this.serviceDiscoveryClient.start();
    }

    protected void execute(Map<String, Object> map) throws Exception {
        String method;
        Preconditions.checkNotNull(httpClient);
        switch (method = String.valueOf(map.get("method"))) {
            case "POST": {
                this.doPost(map);
                break;
            }
            case "PUT": {
                this.doPut(map);
                break;
            }
            case "DELETE": {
                this.doDelete(map);
                break;
            }
            default: {
                this.doGet(map);
            }
        }
    }

    private Response doGet(Map<String, Object> map) throws Exception {
        Request.Builder httpRequest = this.initializeRequest(map);
        httpRequest.get();
        return this.executeRequest(httpRequest.build());
    }

    private Response doDelete(Map<String, Object> map) throws Exception {
        Request.Builder httpRequest = this.initializeRequest(map);
        httpRequest.delete();
        return this.executeRequest(httpRequest.build());
    }

    private Response doPost(Map<String, Object> map) throws Exception {
        Request.Builder httpRequest = this.initializeRequest(map);
        if (map.get("payload") != null) {
            httpRequest.post(RequestBody.create(MediaType.parse(String.valueOf(map.get("contentTypeHeader"))), String.valueOf(map.get("payload"))));
        } else {
            httpRequest.patch(RequestBody.create(MediaType.parse("*/*"), new byte[0]));
        }
        return this.executeRequest(httpRequest.build());
    }

    private Response doPut(Map<String, Object> map) throws Exception {
        Request.Builder httpRequest = this.initializeRequest(map);
        if (map.get("payload") != null) {
            httpRequest.post(RequestBody.create(MediaType.parse(String.valueOf(map.get("contentTypeHeader"))), String.valueOf(map.get("payload"))));
        } else {
            httpRequest.put(RequestBody.create(MediaType.parse("*/*"), new byte[0]));
        }
        return this.executeRequest(httpRequest.build());
    }

    private HttpUrl generateURI(Map<String, Object> map) {
        HttpUrl.Builder builder = new HttpUrl.Builder();
        String secured = String.valueOf(map.get("secured"));
        if ("true".equals(secured)) {
            builder.scheme("https");
        } else {
            builder.scheme("http");
        }
        Optional<ServiceNode<ShardInfo>> node = this.serviceDiscoveryClient.getNode();
        if (!node.isPresent()) {
            log.error("Error executing ranger call! No node available");
            throw new IllegalStateException("Service unavailable");
        }
        builder.host(node.get().getHost()).port(node.get().getPort()).encodedPath(String.valueOf(map.get("uri")));
        return builder.build();
    }

    private Request.Builder initializeRequest(Map<String, Object> map) {
        HttpUrl url = this.generateURI(map);
        log.info("Ranger call URL: " + url);
        Request.Builder httpRequest = new Request.Builder().url(url);
        httpRequest.addHeader("Content-Type", String.valueOf(map.get("contentTypeHeader")));
        httpRequest.addHeader("Accept", String.valueOf(map.get("acceptHeader")));
        return httpRequest;
    }

    private Response executeRequest(Request request) throws Exception {
        try (Response response = null;){
            Response response2 = response = httpClient.newCall(request).execute();
            return response2;
        }
    }

    public void setCuratorFramework(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }
}

