/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.util.List;
import jline.Completor;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.ZooKeeperMain;

class JLineZNodeCompletor
implements Completor {
    private ZooKeeper zk;

    public JLineZNodeCompletor(ZooKeeper zk) {
        this.zk = zk;
    }

    @Override
    public int complete(String buffer, int cursor, List candidates) {
        String[] tokens;
        buffer = buffer.substring(0, cursor);
        String token = "";
        if (!buffer.endsWith(" ") && (tokens = buffer.split(" ")).length != 0) {
            token = tokens[tokens.length - 1];
        }
        if (token.startsWith("/")) {
            return this.completeZNode(buffer, token, candidates);
        }
        return this.completeCommand(buffer, token, candidates);
    }

    private int completeCommand(String buffer, String token, List<String> candidates) {
        for (String cmd : ZooKeeperMain.getCommands()) {
            if (!cmd.startsWith(token)) continue;
            candidates.add(cmd);
        }
        return buffer.lastIndexOf(" ") + 1;
    }

    private int completeZNode(String buffer, String token, List<String> candidates) {
        String path = token;
        int idx = path.lastIndexOf("/") + 1;
        String prefix = path.substring(idx);
        try {
            String dir = idx == 1 ? "/" : path.substring(0, idx - 1);
            List<String> children = this.zk.getChildren(dir, false);
            for (String child : children) {
                if (!child.startsWith(prefix)) continue;
                candidates.add(child);
            }
        }
        catch (InterruptedException e) {
            return 0;
        }
        catch (KeeperException e) {
            return 0;
        }
        return candidates.size() == 0 ? buffer.length() : buffer.lastIndexOf("/") + 1;
    }
}

