/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.guice.providers;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.throwingproviders.CheckedProvider;
import com.redhat.qe.katello.ssl.PEMx509KeyManager;
import com.redhat.qe.katello.ssl.SslPemException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class SSLContextProvider
implements CheckedProvider<SSLContext> {
    @Inject
    private Logger log;
    private final String pem;
    private final TrustManager[] trustManagers;
    private final String PROTOCOL = "TLS";

    @AssistedInject
    public SSLContextProvider(TrustManager[] trustManagers) {
        this(trustManagers, null);
    }

    @AssistedInject
    public SSLContextProvider(TrustManager[] trustManagers, @Assisted String pem) {
        this.trustManagers = trustManagers;
        this.pem = pem;
    }

    public SSLContext get() throws Exception {
        SSLContext clientContext = null;
        if (this.pem == null || "".equals(this.pem)) {
            try {
                clientContext = SSLContext.getInstance("TLS");
                clientContext.init(null, this.trustManagers, new SecureRandom());
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Could not create context", e);
                throw new SslPemException("Failed to initialize the client-side SSLContext", e);
            }
            return clientContext;
        }
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        try {
            this.log.fine("loading thumbslug to cdn entitlement certificate (pem encoded)");
            this.log.fine("Cert is: \n" + this.pem);
            int endOfFirstPart = this.pem.indexOf("\n", this.pem.indexOf("END"));
            if (endOfFirstPart == -1) {
                throw new IllegalArgumentException("unable to parse PEM data");
            }
            String certificate = this.pem.substring(0, endOfFirstPart);
            String privateKey = this.pem.substring(endOfFirstPart);
            if (!certificate.startsWith("-----BEGIN CERTIFICATE-----")) {
                String tmp = privateKey;
                privateKey = certificate;
                certificate = tmp;
            }
            KeyManager[] managers = new PEMx509KeyManager[]{new PEMx509KeyManager()};
            managers[0].addPEM(certificate, privateKey);
            clientContext = SSLContext.getInstance("TLS");
            clientContext.init(managers, this.trustManagers, null);
            this.log.fine("SSL context initialized!");
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Unable to load pem file!", e);
            throw new SslPemException("Failed to initialize the client-side SSLContext", e);
        }
        return clientContext;
    }
}

