/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.api;

import com.google.inject.Inject;
import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloApiException;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.common.KatelloUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-api"})
public class ProvidersTest
extends KatelloTestScript {
    @Inject
    protected static Logger log;
    private String org_name;
    private String provider_name;

    @BeforeClass(description="Prepare an organization to work with")
    public void setUp_createOrg() {
        try {
            this.org_name = this.getDefaultOrg();
        }
        catch (KatelloApiException e) {
            e.printStackTrace();
        }
    }

    @Test(groups={"testProviders"}, description="Create provider")
    public void test_createProvider() {
        String uid = KatelloUtils.getUniqueID();
        this.provider_name = "auto-provider-" + uid;
        KatelloProvider prov = null;
        try {
            prov = this.servertasks.createProvider(this.org_name, this.provider_name, "Provider in test - " + uid, "Custom", null);
        }
        catch (KatelloApiException e1) {
            e1.printStackTrace();
        }
        Assert.assertEquals((String)prov.getName(), (String)this.provider_name, (String)"Katello - Check provider: name");
        Assert.assertEquals((String)prov.getDescription(), (String)("Provider in test - " + uid), (String)"Katello - Check provider: description");
        Assert.assertEquals((String)prov.getProviderType(), (String)"Custom", (String)"Katello - Check provider: provider_type");
        KatelloOrg org = null;
        try {
            org = this.servertasks.getOrganization(this.org_name);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not get org info", (Throwable)e);
        }
        Assert.assertEquals((Object)prov.getOrganizationId(), (Object)org.getId(), (String)"Katello - Check provider: organization_id");
    }

    @Test(groups={"testProviders"}, description="Import Products", dependsOnMethods={"test_createProvider"}, enabled=false)
    public void test_importProducts() {
        String[] attrs;
        String pid = KatelloUtils.getUniqueID();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        String cid = KatelloUtils.getUniqueID();
        String repoUrl = "http://repos.fedorapeople.org/repos/katello/katello/fedora-15/x86_64/";
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.000+0000'");
        String sTS = df.format(Calendar.getInstance().getTime());
        HashMap<String, Object> allProducts = new HashMap<String, Object>();
        HashSet products = new HashSet();
        allProducts.put("products", products);
        HashMap<String, Object> product = new HashMap<String, Object>();
        product.put("updated", sTS);
        product.put("name", "Test Product - " + pid);
        product.put("created", sTS);
        product.put("href", "/products/" + pid);
        HashSet productContentSet = new HashSet();
        HashMap<String, Serializable> productContent = new HashMap<String, Serializable>();
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("contentUrl", repoUrl);
        content.put("updated", sTS);
        content.put("vendor", "redhat");
        content.put("name", "Test Content - " + cid);
        content.put("created", sTS);
        content.put("label", "test-label-" + cid);
        content.put("gpgUrl", "/some/gpg/url/");
        content.put("type", "yum");
        content.put("id", cid);
        productContent.put("content", content);
        productContent.put("physicalEntitlement", Long.valueOf(0L));
        productContent.put("enabled", Boolean.TRUE);
        productContent.put("flexEntitlement", Long.valueOf(0L));
        productContentSet.add(productContent);
        product.put("productContent", productContent);
        product.put("multiplier", 1L);
        HashSet attributes = new HashSet();
        for (String attr : attrs = new String[]{"version:1.0", "variant:ALL", "sockets:2", "arch:ALL", "type:SVC"}) {
            String[] nameValue = attr.split(":");
            HashMap<String, String> attrMap = new HashMap<String, String>();
            attrMap.put("updated", sTS);
            attrMap.put("name", nameValue[0]);
            attrMap.put("value", nameValue[1]);
            attrMap.put("created", sTS);
            attributes.add(attrMap);
        }
        product.put("attributes", attributes);
        product.put("id", pid);
        try {
            this.servertasks.import_products(this.org_name, this.provider_name, allProducts);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not import products", (Throwable)e);
        }
    }

    @Test(groups={"testProviders"}, description="Update Provider Properties", dependsOnMethods={"test_createProvider"})
    public void test_updateProvider() {
        KatelloProvider updProv = null;
        try {
            updProv = this.servertasks.getProvider(this.org_name, this.provider_name);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not get provider", (Throwable)e);
        }
        String upd_repo_url = "https://localhost";
        try {
            Date dupBefore = this.parseKatelloDate(updProv.getUpdatedAt());
            KatelloProvider updatedProvider = null;
            try {
                updatedProvider = this.servertasks.updateProviderProperty(this.org_name, this.provider_name, "name", "modified-" + this.provider_name);
            }
            catch (KatelloApiException e) {
                Assert.fail((String)"Could not update Provider property", (Throwable)e);
            }
            log.info("Date string for updated_at: " + updatedProvider.getUpdatedAt());
            Date dupAfter = this.parseKatelloDate(updatedProvider.getUpdatedAt());
            Assert.assertEquals((String)updatedProvider.getName(), (String)("modified-" + this.provider_name), (String)"Check updated: name");
            Assert.assertMore((Comparable)Long.valueOf(dupAfter.getTime()), (Comparable)Long.valueOf(dupBefore.getTime()), (String)"Check the timestamp updated");
            this.provider_name = "modified-" + this.provider_name;
            dupBefore = dupAfter;
            try {
                updatedProvider = this.servertasks.updateProviderProperty(this.org_name, this.provider_name, "repository_url", upd_repo_url);
            }
            catch (KatelloApiException e) {
                Assert.fail((String)"Could not update Provider property", (Throwable)e);
            }
            dupAfter = this.parseKatelloDate(updatedProvider.getUpdatedAt());
            Assert.assertEquals((String)updatedProvider.getRepositoryUrl(), (String)upd_repo_url, (String)"Check updated: repository_url");
            Assert.assertMore((Comparable)Long.valueOf(dupAfter.getTime()), (Comparable)Long.valueOf(dupBefore.getTime()), (String)"Check the timestamp updated");
            dupBefore = dupAfter;
            try {
                updatedProvider = this.servertasks.updateProviderProperty(this.org_name, this.provider_name, "description", "Updated: provider [" + this.provider_name + "]");
            }
            catch (KatelloApiException e) {
                Assert.fail((String)"Could not update Provider property", (Throwable)e);
            }
            dupAfter = this.parseKatelloDate(updatedProvider.getUpdatedAt());
            Assert.assertEquals((String)updatedProvider.getDescription(), (String)("Updated: provider [" + this.provider_name + "]"), (String)"Check updated: description");
            Assert.assertMore((Comparable)Long.valueOf(dupAfter.getTime()), (Comparable)Long.valueOf(dupBefore.getTime()), (String)"Check the timestamp updated");
        }
        catch (ParseException pex) {
            log.severe(pex.getMessage());
        }
    }

    @Test(groups={"testProviders"}, description="List all providers", dependsOnMethods={"test_updateProvider"})
    public void test_listProviders() {
        List<KatelloProvider> providers = null;
        try {
            providers = this.servertasks.listProviders(this.org_name);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not get provider list", (Throwable)e);
        }
        Assert.assertMore((Comparable)Integer.valueOf(providers.size()), (Comparable)Integer.valueOf(0), (String)"Check: providers count >0");
        boolean findOurProvider = false;
        for (KatelloProvider provider : providers) {
            if (!provider.getName().equals(this.provider_name)) continue;
            findOurProvider = true;
        }
        Assert.assertTrue((boolean)findOurProvider, (String)"Check: we found our provider");
    }

    @Test(groups={"testProviders"}, description="Delete provider", enabled=true)
    public void test_deleteProvider() {
        String uid = KatelloUtils.getUniqueID();
        String providerName = "auto-deleteMe-" + uid;
        KatelloProvider provider = null;
        try {
            provider = this.servertasks.createProvider(this.org_name, providerName, "Provider in test - " + uid, "Custom", null);
        }
        catch (KatelloApiException e1) {
            e1.printStackTrace();
        }
        Assert.assertNotNull(provider, (String)"Returned string in katello is JSON-formatted");
        String sout = null;
        try {
            sout = this.servertasks.deleteProvider(provider);
        }
        catch (KatelloApiException e) {
            // empty catch block
        }
        Assert.assertEquals((String)sout, (String)("Deleted provider [ " + providerName + " ]"), (String)"Check: message returned by the API call");
        try {
            provider = this.servertasks.getProvider(this.org_name, providerName);
        }
        catch (KatelloApiException e) {
            Assert.assertNull((Object)provider, (String)"Check: returned getProvider() is null");
        }
    }

    @Test(groups={"testOrgs", "testProviders"}, description="Generate ", enabled=false)
    public void test_postUeberCert() {
    }
}

