/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloChangeset;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.Arrays;
import java.util.List;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ProductTests
extends KatelloCliTestScript {
    private String org_name;
    private String prov_name;
    private String org_name2;
    private String prov_name2;
    private String prov_name3;

    @BeforeClass(description="Prepare an org to work with", groups={"cli-product"}, alwaysRun=false)
    public void setup_org() {
        String uid = KatelloUtils.getUniqueID();
        this.org_name = "org" + uid;
        this.prov_name = "prov" + uid;
        this.prov_name3 = "prov" + KatelloUtils.getUniqueID();
        KatelloOrg org = new KatelloOrg(this.org_name, null);
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (org create)");
        KatelloProvider prov = new KatelloProvider(this.prov_name, this.org_name, null, null);
        res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (provider create)");
        prov = new KatelloProvider(this.prov_name3, this.org_name, null, null);
        res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (provider create)");
        uid = KatelloUtils.getUniqueID();
        this.org_name2 = "org" + uid;
        this.prov_name2 = "prov" + uid;
        org = new KatelloOrg(this.org_name2, null);
        res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (org create)");
        prov = new KatelloProvider(this.prov_name2, this.org_name2, null, null);
        res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (provider create)");
    }

    @Test(description="List all product for orgs", groups={"headpin-cli"})
    public void test_listProductDefaultOrg() {
        String providername = "Red Hat";
        KatelloProduct list_product = new KatelloProduct(null, "ACME_Corporation", providername, null, null, null, null, null);
        SSHCommandResult res = list_product.cli_list();
        Assert.assertEquals((int)res.getExitCode(), (int)0, (String)"Check - return code");
    }

    @Test(description="create product - no url specified", groups={"cli-products"}, enabled=true)
    public void test_createProduct_noUrl() {
        String uid = KatelloUtils.getUniqueID();
        String prodName = "prodCreate-" + uid;
        KatelloProduct prod = new KatelloProduct(prodName, this.org_name, this.prov_name, null, null, null, null, null);
        SSHCommandResult res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created product [ %s ]", prodName)), (String)"Check - returned output string (product create)");
        prod.assert_productExists(null, false);
    }

    @Test(description="create product - with single repo", groups={"cli-products"}, enabled=true)
    public void test_createProduct_urlSingleRepo() {
        String uid = KatelloUtils.getUniqueID();
        String prodName = "prod1Repo-" + uid;
        KatelloProduct prod = new KatelloProduct(prodName, this.org_name, this.prov_name, null, null, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/x86_64/", null, true);
        SSHCommandResult res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created product [ %s ]", prodName)), (String)"Check - returned output string (product create)");
        prod.assert_productExists(null, false);
        KatelloRepo repo = new KatelloRepo(null, this.org_name, prodName, null, null, null);
        res = repo.list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (repo list by product)");
        String REGEXP_PRODUCT_LIST = ".*Id:\\s+\\d+.*Name:\\s+" + prodName + "_.*";
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_PRODUCT_LIST), (String)"Repo list should contain info about just created repo (requested by: org, product)");
    }

    @Test(description="create product - with multiple repos", groups={"cli-products"}, enabled=true)
    public void test_createProduct_urlMultipleRepo() {
        String line;
        int i;
        String uid = KatelloUtils.getUniqueID();
        String prodName = "prod2Repos-" + uid;
        KatelloProduct prod = new KatelloProduct(prodName, this.org_name, this.prov_name, null, null, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/", null, true);
        SSHCommandResult res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created product [ %s ]", prodName)), (String)"Check - returned output string (product create)");
        prod.assert_productExists(null, false);
        KatelloRepo repo = new KatelloRepo(null, this.org_name, prodName, null, null, null);
        res = repo.list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (repo list by product)");
        String REGEXP_PRODUCT_LIST_I386 = "..*Id:\\s+\\d+.*Name:\\s+" + prodName + "_.*_i386.*";
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_PRODUCT_LIST_I386), (String)"Repo list should contain info about just created repo (requested by: org, product - i386)");
        String REGEXP_PRODUCT_LIST_X86_64 = ".*Id:\\s+\\d+.*Name:\\s+" + prodName + "_.*_x86_64.*";
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_PRODUCT_LIST_X86_64), (String)"Repo list should contain info about just created repo (requested by: org, product - x86_64)");
        repo = new KatelloRepo(null, this.org_name, prodName, null, null, null);
        SSHCommandResult resRepos = repo.list();
        String REGEXP_PACKAGE_CNT = ".*Package Count:\\s+0.*";
        String repoName = KatelloCli.grepCLIOutput("Name", this.getOutput(resRepos), 1);
        KatelloRepo repoWithName = new KatelloRepo(repoName, this.org_name, prodName, null, null, null);
        res = repoWithName.info();
        String[] lines = this.getOutput(res).split("\n");
        for (i = 0; i < lines.length; ++i) {
            line = lines[i];
            if (!line.startsWith("Package Count:")) continue;
            Assert.assertTrue((boolean)line.matches(REGEXP_PACKAGE_CNT), (String)"Repo list of the product - should contain package count 0");
        }
        repoName = KatelloCli.grepCLIOutput("Name", this.getOutput(resRepos), 2);
        repoWithName = new KatelloRepo(repoName, this.org_name, prodName, null, null, null);
        res = repoWithName.info();
        lines = this.getOutput(res).split("\n");
        for (i = 0; i < lines.length; ++i) {
            line = lines[i];
            if (!line.startsWith("Package Count:")) continue;
            Assert.assertTrue((boolean)line.matches(REGEXP_PACKAGE_CNT), (String)"Repo list of the product - should contain package count 0");
        }
    }

    @Test(description="create product by existing name", groups={"cli-products"}, enabled=true)
    public void test_createProduct_exists() {
        String uid = KatelloUtils.getUniqueID();
        String prodName = "existing-" + uid;
        KatelloProduct prod = new KatelloProduct(prodName, this.org_name, this.prov_name, null, null, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/", null, true);
        SSHCommandResult res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        res = prod.create();
        Assert.assertTrue((res.getExitCode() == 144 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        Assert.assertTrue((boolean)this.getOutput(res).trim().contains("Validation failed: Pulp id has already been taken"), (String)"Check - error message pulp id is taken");
    }

    @Test(description="create product by the same name which is in other org", groups={"cli-products"}, enabled=true)
    public void test_createProduct_sameName() {
        String uid = KatelloUtils.getUniqueID();
        String prodName = "existing-" + uid;
        KatelloProduct prod = new KatelloProduct(prodName, this.org_name, this.prov_name, null, null, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/", null, true);
        SSHCommandResult res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        prod = new KatelloProduct(prodName, this.org_name2, this.prov_name2, null, null, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/", null, true);
        res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created product [ %s ]", prodName)), (String)"Check - returned output string (product create)");
        prod.assert_productExists(null, false);
    }

    @Test(description="product status output check", groups={"cli-products"}, enabled=true)
    public void test_productStatus() {
        String prodName1 = "prod1-" + KatelloUtils.getUniqueID();
        String prodName2 = "prod2-" + KatelloUtils.getUniqueID();
        String envName1 = "env1-" + KatelloUtils.getUniqueID();
        KatelloProduct prod1 = new KatelloProduct(prodName1, this.org_name, this.prov_name, null, null, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/i386/", null, true);
        SSHCommandResult res = prod1.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        res = prod1.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product synchronize)");
        KatelloEnvironment env1 = new KatelloEnvironment(envName1, null, this.org_name, "Library");
        res = env1.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (environment create)");
        res = prod1.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product synchronize)");
        res = prod1.promote(envName1);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product promote)");
        prod1.syncState = "Finished";
        KatelloProduct prod2 = new KatelloProduct(prodName2, this.org_name, this.prov_name3, null, null, null, null, true);
        res = prod2.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        this.assert_productStatus(prod1);
        this.assert_productStatus(prod2);
    }

    @Test(description="list the products by provider", groups={"cli-products"}, enabled=true)
    public void test_listProduct_provider() {
        String prodName1 = "prod1-" + KatelloUtils.getUniqueID();
        String prodName2 = "prod2-" + KatelloUtils.getUniqueID();
        String prodName3 = "prod3-" + KatelloUtils.getUniqueID();
        KatelloProduct prod1 = new KatelloProduct(prodName1, this.org_name, this.prov_name, null, null, null, null, true);
        SSHCommandResult res = prod1.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        KatelloProduct prod2 = new KatelloProduct(prodName2, this.org_name, this.prov_name, null, null, null, null, true);
        res = prod2.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        KatelloProduct prod3 = new KatelloProduct(prodName3, this.org_name, this.prov_name3, null, null, null, null, true);
        res = prod3.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        SSHCommandResult exec_result = prod1.cli_list_provider(this.prov_name);
        this.assert_productList(exec_result, Arrays.asList(prod1, prod2), Arrays.asList(prod3));
    }

    @Test(description="list the products by environment", groups={"cli-products"}, enabled=true)
    public void test_listProduct_environment() {
        String lastSync2;
        String lastSync1;
        String prodName1 = "prod1-" + KatelloUtils.getUniqueID();
        String prodName2 = "prod2-" + KatelloUtils.getUniqueID();
        String prodName3 = "prod3-" + KatelloUtils.getUniqueID();
        String envName1 = "env1-" + KatelloUtils.getUniqueID();
        String envName2 = "env2-" + KatelloUtils.getUniqueID();
        KatelloProduct prod1 = new KatelloProduct(prodName1, this.org_name, this.prov_name, null, null, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/i386/", null, true);
        SSHCommandResult res = prod1.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        res = prod1.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product synchronize)");
        KatelloEnvironment env1 = new KatelloEnvironment(envName1, null, this.org_name, "Library");
        res = env1.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (environment create)");
        res = prod1.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product synchronize)");
        res = prod1.promote(envName1);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product promote)");
        KatelloProduct prod2 = new KatelloProduct(prodName2, this.org_name, this.prov_name, null, null, "http://inecas.fedorapeople.org/fakerepos/zoo3/", null, true);
        res = prod2.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        res = prod2.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product synchronize)");
        KatelloEnvironment env2 = new KatelloEnvironment(envName2, null, this.org_name, "Library");
        res = env2.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (environment create)");
        res = prod2.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product synchronize)");
        res = prod2.promote(envName2);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product promote)");
        KatelloProduct prod3 = new KatelloProduct(prodName3, this.org_name, this.prov_name3, null, null, null, null, true);
        res = prod3.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        res = prod1.status();
        prod1.lastSync = lastSync1 = KatelloCli.grepCLIOutput("Last Sync", this.getOutput(res).trim(), 1);
        res = prod2.status();
        prod2.lastSync = lastSync2 = KatelloCli.grepCLIOutput("Last Sync", this.getOutput(res).trim(), 1);
        res = prod1.cli_list(envName1);
        this.assert_productList(res, Arrays.asList(prod1), Arrays.asList(prod2, prod3));
        res = prod1.cli_list(envName2);
        this.assert_productList(res, Arrays.asList(prod2), Arrays.asList(prod1, prod3));
    }

    @Test(description="promote product", groups={"cli-products"}, enabled=true)
    public void test_promoteProduct_NoRepos() {
        String uid = KatelloUtils.getUniqueID();
        String prodName = "promoNoRepo-" + uid;
        KatelloProduct prod = new KatelloProduct(prodName, this.org_name, this.prov_name, null, null, null, null, null);
        SSHCommandResult res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created product [ %s ]", prodName)), (String)"Check - returned output string (product create)");
        prod.assert_productExists(null, false);
        String envName = "dev-" + uid;
        KatelloEnvironment env = new KatelloEnvironment(envName, null, this.org_name, "Library");
        res = env.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (environment create)");
        res = prod.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product synchronize)");
        res = prod.promote(envName);
        Assert.assertTrue((res.getExitCode() == 148 ? 1 : 0) != 0, (String)"Check - return code (product promote)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Couldn't find Product with cp_id = ", prodName)), (String)"Check - returned output string (product promote)");
    }

    @Test(description="promote product", groups={"cli-products"}, enabled=true)
    public void test_promoteProduct_OneRepo() {
        String uid = KatelloUtils.getUniqueID();
        String prodName = "promo1Repo-" + uid;
        String envName = "dev-" + uid;
        KatelloProduct prod = new KatelloProduct(prodName, this.org_name, this.prov_name, null, null, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/x86_64/", null, true);
        SSHCommandResult res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created product [ %s ]", prodName)), (String)"Check - returned output string (product create)");
        prod.assert_productExists(null, false);
        KatelloEnvironment env = new KatelloEnvironment(envName, null, this.org_name, "Library");
        res = env.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (environment create)");
        res = prod.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product synchronize)");
        res = prod.promote(envName);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product promote)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Product [ %s ] promoted to environment [ %s ]", prodName, envName)), (String)"Check - returned output string (product promote)");
        res = prod.cli_list(envName);
        String REGEXP_PRODUCT_LIST = ".*Id:\\s+\\d+Name:\\s+" + prodName + ".*Provider Name:\\s+" + this.prov_name + ".*";
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_PRODUCT_LIST), (String)"Product list by environment - just promoted product");
        KatelloRepo repo = new KatelloRepo(null, this.org_name, prodName, null, null, null);
        res = repo.list(envName);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (repo list by product)");
        String REGEXP_REPO_LIST = ".*Id:\\s+\\d+.*Name:\\s+" + prodName + "_.*";
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_REPO_LIST), (String)"Repo list should contain info about just created repo (requested by: org, environment)");
    }

    @Test(description="promote product", groups={"cli-products"}, enabled=true)
    public void test_promoteProduct_MultipleRepos() {
        String uid = KatelloUtils.getUniqueID();
        String prodName = "promo1Repo-" + uid;
        String envName = "dev-" + uid;
        KatelloProduct prod = new KatelloProduct(prodName, this.org_name, this.prov_name, null, null, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/", null, true);
        SSHCommandResult res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created product [ %s ]", prodName)), (String)"Check - returned output string (product create)");
        prod.assert_productExists(null, false);
        KatelloEnvironment env = new KatelloEnvironment(envName, null, this.org_name, "Library");
        res = env.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (environment create)");
        res = prod.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product synchronize)");
        res = prod.promote(envName);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product promote)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Product [ %s ] promoted to environment [ %s ]", prodName, envName)), (String)"Check - returned output string (product promote)");
        res = prod.cli_list(envName);
        String REGEXP_PRODUCT_LIST = ".*Id:\\s+\\d+Name:\\s+" + prodName + ".*Provider Name:\\s+" + this.prov_name + ".*";
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_PRODUCT_LIST), (String)"Product list by environment - just promoted product");
        KatelloRepo repo = new KatelloRepo(null, this.org_name, prodName, null, null, null);
        res = repo.list(envName);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (repo list by product)");
        String REGEXP_PRODUCT_LIST_I386 = ".*Id:\\s+\\d+.*Name:\\s+" + prodName + "_.*_i386.*";
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_PRODUCT_LIST_I386), (String)"Repo list should contain info about just created repo (requested by: org, product - i386)");
        String REGEXP_PRODUCT_LIST_X86_64 = ".*Id:\\s+\\d+.*Name:\\s+" + prodName + "_.*_x86_64.*";
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_PRODUCT_LIST_X86_64), (String)"Repo list should contain info about just created repo (requested by: org, product - x86_64)");
    }

    @Test(description="sync product - single repo", groups={"cli-products"}, enabled=true)
    public void test_syncronizeProduct_SingleRepo() {
        String uid = KatelloUtils.getUniqueID();
        String prodName = "sync1Repo-" + uid;
        KatelloProduct prod = new KatelloProduct(prodName, this.org_name, this.prov_name, null, null, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/i386/", null, true);
        SSHCommandResult res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created product [ %s ]", prodName)), (String)"Check - returned output string (product create)");
        prod.assert_productExists(null, false);
        res = prod.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product synchronize)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Product [ %s ] synchronized", prodName)), (String)"Check - returned output string (product synchronize)");
        KatelloRepo repo = new KatelloRepo(null, this.org_name, prodName, null, null, null);
        res = repo.list();
        String REGEXP_REPO_LIST = ".*Package Count:\\s+0.*";
        Assert.assertFalse((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_REPO_LIST), (String)"Repo list of the product - should not contain package count 0 (after product synchronize)");
    }

    @Test(description="sync product - multiple repos", groups={"cli-products"}, enabled=true)
    public void test_syncronizeProduct_MultipleRepos() {
        String line;
        int i;
        String uid = KatelloUtils.getUniqueID();
        String prodName = "syncManyRepos-" + uid;
        KatelloProduct prod = new KatelloProduct(prodName, this.org_name, this.prov_name, null, null, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/", null, true);
        SSHCommandResult res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created product [ %s ]", prodName)), (String)"Check - returned output string (product create)");
        prod.assert_productExists(null, false);
        res = prod.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product synchronize)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Product [ %s ] synchronized", prodName)), (String)"Check - returned output string (product synchronize)");
        KatelloRepo repo = new KatelloRepo(null, this.org_name, prodName, null, null, null);
        SSHCommandResult resRepos = repo.list();
        String REGEXP_PACKAGE_CNT = ".*Package Count:\\s+0.*";
        String repoName = KatelloCli.grepCLIOutput("Name", resRepos.getStdout(), 1);
        repo = new KatelloRepo(repoName, this.org_name, prodName, null, null, null);
        res = repo.info();
        String[] lines = this.getOutput(res).split("\n");
        for (i = 0; i < lines.length; ++i) {
            line = lines[i];
            if (!line.startsWith("Package Count:")) continue;
            Assert.assertFalse((boolean)line.matches(REGEXP_PACKAGE_CNT), (String)"Repo list of the product - should not contain package count 0 (after product synchronize)");
        }
        repoName = KatelloCli.grepCLIOutput("Name", resRepos.getStdout(), 2);
        repo = new KatelloRepo(repoName, this.org_name, prodName, null, null, null);
        res = repo.info();
        lines = this.getOutput(res).split("\n");
        for (i = 0; i < lines.length; ++i) {
            line = lines[i];
            if (!line.startsWith("Package Count:")) continue;
            Assert.assertFalse((boolean)line.matches(REGEXP_PACKAGE_CNT), (String)"Repo list of the product - should not contain package count 0 (after product synchronize)");
        }
    }

    @Test(description="delete product - included in some changeset", groups={"cli-products"}, enabled=true)
    public void test_deleteProduct_InChangeset() {
        String uid = KatelloUtils.getUniqueID();
        String prodName = "delProd1-" + uid;
        String envName_dev = "dev-" + uid;
        String csName = "cs-" + uid;
        KatelloProduct prod = new KatelloProduct(prodName, this.org_name, this.prov_name, null, null, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/x86_64/", null, true);
        SSHCommandResult res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        res = prod.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product synchronize)");
        KatelloEnvironment env = new KatelloEnvironment(envName_dev, null, this.org_name, "Library");
        res = env.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (environment create)");
        KatelloChangeset cs = new KatelloChangeset(csName, this.org_name, envName_dev);
        res = cs.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset create)");
        res = cs.update_addProduct(prodName);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset update --add_product)");
        res = cs.apply();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset promote)");
        KatelloRepo repo = new KatelloRepo(null, this.org_name, prodName, null, null, null);
        res = repo.list(envName_dev);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (repo list --environment)");
        String REGEXP_PRODUCT_LIST_X86_64 = ".*Id:\\s+\\d+.*Name:\\s+" + prodName + "_.*_x86_64.*";
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_PRODUCT_LIST_X86_64), (String)"Repo list by environment - should contain info");
        res = prod.cli_list(envName_dev);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product list --environment)");
        String REGEXP_PRODUCT_LIST = ".*Name:\\s+" + prodName + ".*Provider Name:\\s+" + this.prov_name + ".*";
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_PRODUCT_LIST), (String)"List should contain info about product (requested by: environment)");
        res = prod.status();
        String prodId = KatelloCli.grepCLIOutput("Id", res.getStdout());
        res = prod.delete();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Deleted product '%s'", prodId)), (String)"Check - returned output string (product delete)");
        res = prod.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product list --provider)");
        REGEXP_PRODUCT_LIST = ".*Name:\\s+" + prodName + ".*Provider Name:\\s+" + this.prov_name + ".*";
        Assert.assertFalse((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_PRODUCT_LIST), (String)"Check - list should NOT contain info about product (deleted already)");
        repo = new KatelloRepo(null, this.org_name, prodName, null, null, null);
        res = repo.list();
        Assert.assertTrue((res.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code (repo list --product)");
        Assert.assertTrue((boolean)this.getOutput(res).equals(String.format("Could not find product [ %s ] within organization [ %s ]", prodName, this.org_name)), (String)"Check - `repo list --product` output string");
        repo = new KatelloRepo(null, this.org_name, prodName, null, null, null);
        res = repo.list(envName_dev);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (repo list --environment)");
        String REGEXP_NOREPO = ".*Id:\\s+\\d+.*Name:\\s+.*";
        Assert.assertFalse((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_NOREPO), (String)"Check - `repo list --environment` output string");
        res = prod.cli_list(envName_dev);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product list --environment)");
        REGEXP_PRODUCT_LIST = ".*Name:\\s+" + prodName + ".*Provider Name:\\s+" + this.prov_name + ".*";
        Assert.assertFalse((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_PRODUCT_LIST), (String)"Check - list should NOT contain info about product (deleted already)");
    }

    private void assert_productList(SSHCommandResult exec_result, List<KatelloProduct> products, List<KatelloProduct> excludeProducts) {
        String match_info;
        for (KatelloProduct prod : products) {
            if (prod.syncPlanName == null) {
                prod.syncPlanName = "None";
            }
            if (prod.lastSync == null) {
                prod.lastSync = "never";
            }
            if (prod.gpgkey == null) {
                prod.gpgkey = "";
            }
            match_info = String.format(".*Id:\\s+\\d+.*Name:\\s+%s.*Provider Id:\\s+\\d+.*Provider Name:\\s+%s.*Sync Plan Name:\\s+%s.*Last Sync:\\s+%s.*GPG key:\\s*%s.*", prod.getName(), prod.provider, prod.syncPlanName, prod.lastSync, prod.gpgkey).replaceAll("\"", "");
            Assert.assertTrue((boolean)this.getOutput(exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("Product [%s] should be found in the result list", prod.getName()));
        }
        for (KatelloProduct prod : excludeProducts) {
            if (prod.syncPlanName == null) {
                prod.syncPlanName = "None";
            }
            if (prod.lastSync == null) {
                prod.lastSync = "never";
            }
            if (prod.gpgkey == null) {
                prod.gpgkey = "";
            }
            match_info = String.format(".*Id:\\s+\\d+.*Name:\\s+%s.*Provider Id:\\s+\\d+.*Provider Name:\\s+%s.*Sync Plan Name:\\s+%s.*Last Sync:\\s+%s.*GPG key:\\s*%s.*", prod.getName(), prod.provider, prod.syncPlanName, prod.lastSync, prod.gpgkey).replaceAll("\"", "");
            Assert.assertFalse((boolean)this.getOutput(exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("Product [%s] should be found in the result list", prod.getName()));
        }
    }

    private String assert_productStatus(KatelloProduct product) {
        if (product.syncState == null) {
            product.syncState = "Not synced";
        }
        SSHCommandResult res = product.status();
        String match_info = String.format(".*Id:\\s+\\d+.*Name:\\s+%s.*Provider Id:\\s+\\d+.*Provider Name:\\s+%s.*Last Sync:\\s+.*Sync State:\\s+%s.*", product.name, product.provider, product.syncState).replaceAll("\"", "");
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        log.finest(String.format("Product (status) match regex: [%s]", match_info));
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Product [%s] should be found in the result", product.name));
        String lastSync = KatelloCli.grepCLIOutput("Last Sync", this.getOutput(res).trim(), 1);
        if (product.syncState.equals("Not synced")) {
            Assert.assertEquals((String)lastSync, (String)"never");
        } else {
            Assert.assertMatch((String)lastSync, (String)"\\d{4}/\\d{2}/\\d{2}\\s\\d{2}:\\d{2}:\\d{2}");
        }
        return KatelloCli.grepCLIOutput("Id", this.getOutput(res).trim(), 1);
    }
}

