/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.e2e;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloChangeset;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-e2e"})
public class BPMTests
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(BPMTests.class.getName());
    private SSHCommandResult exec_result;
    private String org_name;
    private String user_name;
    private String providerF_name;
    private String product_name;
    private String repo_name_pulpRHEL6;
    private String env_name_Dev;
    private String env_name_Prod;
    private String changeset_name;
    private String consumer_name;
    private String rhsm_pool_id;

    @BeforeClass(description="Generate unique names")
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.org_name = "orgBPM_" + uid;
        this.user_name = "userBPMAdmin_" + uid;
        this.providerF_name = "providerBPM_F_" + uid;
        this.product_name = "productBPM_" + uid;
        this.repo_name_pulpRHEL6 = "repoBPM_pulpRHEL6_" + uid;
        this.env_name_Dev = "envBPM_Dev_" + uid;
        this.env_name_Prod = "envBPM_Prod_" + uid;
        this.changeset_name = "changesetBPM_" + uid;
        this.consumer_name = uid + "-`hostname`";
        this.rhsm_pool_id = null;
        log.info("Clean RHSM registration");
        KatelloUtils.sshOnClient("subscription-manager unregister || true");
    }

    @Test(description="Create a new Org and create a user who can manage providers, systems and environments.")
    public void test_createOrgUser() {
        KatelloOrg org = new KatelloOrg(this.org_name, "BPM tests");
        this.exec_result = org.cli_create();
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)("Successfully created org [ " + this.org_name + " ]"));
        KatelloUser user = new KatelloUser(this.user_name, "root@localhost", "testing", false);
        this.exec_result = user.cli_create();
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)("Successfully created user [ " + this.user_name + " ]"));
    }

    @Test(description="Create a Custom Provider with a product that mirrors Fedora", dependsOnMethods={"test_createOrgUser"})
    public void test_createProviderProduct() {
        KatelloProvider prov = new KatelloProvider(this.providerF_name, this.org_name, "Fedora provider", null);
        this.exec_result = prov.create();
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)("Successfully created provider [ " + this.providerF_name + " ]"));
        KatelloProduct prod = new KatelloProduct(this.product_name, this.org_name, this.providerF_name, null, null, null, null, null);
        this.exec_result = prod.create();
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)("Successfully created product [ " + this.product_name + " ]"));
    }

    @Test(description="Sync the Red Hat and Fedora Content", dependsOnMethods={"test_createProviderProduct"})
    public void test_syncRepo() {
        KatelloRepo repo = new KatelloRepo(this.repo_name_pulpRHEL6, this.org_name, this.product_name, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/x86_64/", null, null);
        this.exec_result = repo.create();
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)("Successfully created repository [ " + this.repo_name_pulpRHEL6 + " ]"));
        KatelloProvider prov = new KatelloProvider(this.providerF_name, this.org_name, "Fedora provider", null);
        this.exec_result = prov.synchronize();
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        String[] res = this.getOutput(this.exec_result).trim().split("\n");
        Assert.assertEquals((String)res[res.length - 1], (String)("Provider [ " + this.providerF_name + " ] synchronized"));
    }

    @Test(description="Create a new environment, and promote the content to the new environment.", dependsOnMethods={"test_syncRepo"})
    public void test_createEnvPromoteContent() {
        KatelloEnvironment env = new KatelloEnvironment(this.env_name_Dev, null, this.org_name, "Library");
        this.exec_result = env.cli_create();
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)("Successfully created environment [ " + this.env_name_Dev + " ]"));
        env = new KatelloEnvironment(this.env_name_Prod, null, this.org_name, this.env_name_Dev);
        this.exec_result = env.cli_create();
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)("Successfully created environment [ " + this.env_name_Prod + " ]"));
        KatelloChangeset cs = new KatelloChangeset(this.changeset_name, this.org_name, this.env_name_Dev);
        this.exec_result = cs.create();
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)("Successfully created changeset [ " + this.changeset_name + " ] for environment [ " + this.env_name_Dev + " ]"));
        this.exec_result = cs.update_addProduct(this.product_name);
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)("Successfully updated changeset [ " + this.changeset_name + " ]"));
        this.exec_result = cs.apply();
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).endsWith("applied"));
    }

    @Test(description="From both a RH and Fedora machine, register the machine using subscription manager.", dependsOnMethods={"test_createEnvPromoteContent"})
    public void test_rhsm_register() {
        this.exec_result = KatelloUtils.sshOnClient(String.format("subscription-manager register --username admin --password admin --org %s --environment %s --name %s", this.org_name, this.env_name_Dev, this.consumer_name));
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("The system has been registered with id:"), (String)"Check - returned message");
        log.finest("Sleeping 3 sec. giving chance system to recognize the registration.");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test(description="List available subscriptions", dependsOnMethods={"test_rhsm_register"})
    public void test_rhsm_listAvailableSubscriptions() {
        this.exec_result = KatelloUtils.sshOnClient("subscription-manager list --available | grep -E \"Product Name:\"");
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(this.product_name), (String)"Check - subscription.ProductName");
        this.exec_result = KatelloUtils.sshOnClient("subscription-manager list --available | grep Quantity:");
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("unlimited"), (String)"Check - subscription.Quantity");
        this.exec_result = KatelloUtils.sshOnClient("subscription-manager list --available | grep -E \"Pool Id:\"");
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        this.rhsm_pool_id = this.getOutput(this.exec_result).trim().split(":")[1].trim();
        log.fine(String.format("Subscription is available for product: [%s] with poolid: [%s]", this.product_name, this.rhsm_pool_id));
    }

    @Test(description="Subscribe to pool", dependsOnMethods={"test_rhsm_listAvailableSubscriptions"})
    public void test_rhsm_subscribeToPool() {
        Assert.assertNotNull((Object)this.rhsm_pool_id, (String)"Check - pool id is set");
        this.exec_result = KatelloUtils.sshOnClient("subscription-manager subscribe --pool " + this.rhsm_pool_id);
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).trim().startsWith("Successfully"), (String)"Check - returned message (Successfully)");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).trim().contains(this.rhsm_pool_id), (String)"Check - returned message (pool ID)");
    }

    @Test(description="Yum should work - yum info pulp-consumer", dependsOnMethods={"test_rhsm_subscribeToPool"})
    public void test_yuminfo() {
        String pkg_pulp_consumer = "pulp-consumer";
        this.exec_result = KatelloUtils.sshOnClient("yum info " + pkg_pulp_consumer + " --disablerepo=* --enablerepo=*" + this.repo_name_pulpRHEL6 + "*");
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        String YUM_INFO_PULP_CONSUMER = ".*Available Packages.*Name\\s+:\\s+" + pkg_pulp_consumer + ".*Repo\\s+:\\s+.*" + this.repo_name_pulpRHEL6 + ".*";
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).replaceAll("\n", "").matches(YUM_INFO_PULP_CONSUMER), (String)("package " + pkg_pulp_consumer + " should be returned in yum info"));
    }

    @AfterTest(description="erase registration made; cleanup", alwaysRun=true)
    public void tearDown() {
        KatelloUtils.sshOnClient("subscription-manager clean");
    }
}

