/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.e2e;

import com.google.inject.Inject;
import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloApiException;
import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloSystem;
import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.katello.tasks.KatelloTasks;
import com.redhat.qe.katello.tests.e2e.BPMTests;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-e2e"})
public class ConsumerAccess
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(BPMTests.class.getName());
    private SSHCommandResult exec_result;
    private final KatelloTasks katelloTasks;
    private String org_name;
    private String env_name;
    private String user_name;
    private String system_name;

    @Inject
    public ConsumerAccess(KatelloTasks katelloTasks) {
        this.katelloTasks = katelloTasks;
    }

    @BeforeClass(description="Generate unique names")
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.org_name = "org_" + uid;
        this.env_name = "env_" + uid;
        this.user_name = "user_" + uid;
        this.system_name = "system_" + uid;
        KatelloUtils.sshOnClient("yum -y erase wolf lion || true");
        KatelloUtils.sshOnClient("subscription-manager unregister || true");
        KatelloOrg org = new KatelloOrg(this.org_name, "Org deletion");
        this.exec_result = org.cli_create();
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)("Successfully created org [ " + this.org_name + " ]"));
        KatelloEnvironment env = new KatelloEnvironment(this.env_name, null, this.org_name, "Library");
        this.exec_result = env.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloUser user = null;
        try {
            user = this.katelloTasks.createUser(this.user_name, "root@localhost", "testing", false);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not create user", (Throwable)e);
        }
        Assert.assertNotNull(user, (String)"Check - return string not null");
    }

    @Test(description="Retrieve consumer")
    public void test_consumerRetrieve() {
        KatelloUtils.sshOnClient("subscription-manager clean");
        KatelloSystem sys = new KatelloSystem(this.system_name, this.org_name, null);
        this.exec_result = sys.rhsm_register();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = sys.rhsm_identity();
        String id = KatelloCli.grepCLIOutput("Current identity is", this.getOutput(this.exec_result).trim(), 1);
        this.exec_result = KatelloUtils.sshOnClient("curl -H \"Content-Type: application/json\" -H \"Accept: application/json\" -#  -k -u " + this.user_name + ":" + "testing" + " https://localhost/" + System.getProperty("katello.product", "katello") + "/api/consumers/" + id);
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).replaceAll("\n", "").contains("User " + this.user_name + " is not allowed to access api/systems/show"), (String)"Check - access denied output");
        this.exec_result = KatelloUtils.sshOnClient("curl -H \"Content-Type: application/json\" -H \"Accept: application/json\" -#  -k -u admin:admin https://localhost/" + System.getProperty("katello.product", "katello") + "/api/consumers/" + id);
        Assert.assertFalse((boolean)this.getOutput(this.exec_result).replaceAll("\n", "").contains("User admin is not allowed to access api/systems/show"), (String)"Check - access granted output");
    }
}

