/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.e2e;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.katello.tests.e2e.BPMTests;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import org.testng.annotations.Test;

@Test(groups={"cfse-e2e"})
public class OrgDeletion
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(BPMTests.class.getName());
    private SSHCommandResult exec_result;
    private String org_name;
    private String repo_name;
    private String env_name;
    private String provider_name;
    private String product_name;
    private String ls_cmd = "ls -la /var/lib/pulp/repos/";

    @Test(description="Create a new Org, add repo, sync it, delete the org, verify that repo is deleted from file system.")
    public void test_deleteOrg() {
        KatelloOrg org = this.createOrgStuff(null);
        this.exec_result = KatelloUtils.sshOnClient(this.ls_cmd + org.name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = org.delete();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully deleted org [ %s ]", org.name)), (String)"Check - return string");
        this.exec_result = KatelloUtils.sshOnClient(this.ls_cmd + org.name);
        Assert.assertTrue((this.exec_result.getExitCode() == 2 ? 1 : 0) != 0, (String)"Check - return code");
        this.createOrgStuff(org.name);
    }

    @Test(description="Create 2 Orgs, add same repo to them, sync them, delete the first org, verify that repo is deleted from file system only for first org.")
    public void test_deleteOrgSharingRepo() {
        KatelloOrg org = this.createOrgStuff(null);
        KatelloOrg org2 = this.createOrgStuff(null);
        this.exec_result = KatelloUtils.sshOnClient(this.ls_cmd + org.name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = KatelloUtils.sshOnClient(this.ls_cmd + org2.name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = org.delete();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully deleted org [ %s ]", org.name)), (String)"Check - return string");
        this.exec_result = KatelloUtils.sshOnClient(this.ls_cmd + org.name);
        Assert.assertTrue((this.exec_result.getExitCode() == 2 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = KatelloUtils.sshOnClient(this.ls_cmd + org2.name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.createOrgStuff(org.name);
    }

    private KatelloOrg createOrgStuff(String name) {
        String uid = KatelloUtils.getUniqueID();
        this.org_name = name == null ? "Paris" + uid : name;
        this.repo_name = "Pulp" + uid;
        this.env_name = "Dev" + uid;
        this.provider_name = "provider" + uid;
        this.product_name = "product" + uid;
        KatelloOrg org = new KatelloOrg(this.org_name, "Org deletion");
        this.exec_result = org.cli_create();
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)("Successfully created org [ " + this.org_name + " ]"));
        KatelloProvider prov = new KatelloProvider(this.provider_name, this.org_name, "Package provider", "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/x86_64/");
        this.exec_result = prov.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod = new KatelloProduct(this.product_name, this.org_name, this.provider_name, null, null, null, null, null);
        this.exec_result = prod.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloRepo repo = new KatelloRepo(this.repo_name, this.org_name, this.product_name, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/x86_64/", null, null);
        this.exec_result = repo.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloEnvironment env = new KatelloEnvironment(this.env_name, null, this.org_name, "Library");
        this.exec_result = env.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = prov.synchronize();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        return org;
    }
}

