/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base;

import com.redhat.qe.auto.testng.TestScript;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;

public class KatelloApi {
    protected static Logger log = Logger.getLogger(KatelloApi.class.getName());

    public static ClientExecutor createExecutor() {
        String userId = System.getProperty("katello.admin.user", "admin");
        String password = System.getProperty("katello.admin.password", "admin");
        BasicHttpParams params = new BasicHttpParams();
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }
            }}, new SecureRandom());
            SSLSocketFactory sf = new SSLSocketFactory(sslContext);
            Scheme httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)sf);
            schemeRegistry.register(httpsScheme);
        }
        catch (Exception e) {
            System.err.println("HttpClient: Scheme not initialized properly");
            e.printStackTrace();
        }
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager(schemeRegistry);
        cm.setDefaultMaxPerRoute(10);
        String hostname = System.getProperty("katello.server.hostname", "localhost");
        int port = Integer.valueOf(System.getProperty("katello.server.port", "443"));
        HttpHost targetHost = new HttpHost(hostname, port, "https");
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
        httpClient.getCredentialsProvider().setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(userId, password));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        BasicHttpContext localcontext = new BasicHttpContext();
        localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
        return new ApacheHttpClient4Executor((HttpClient)httpClient, (HttpContext)localcontext);
    }

    static {
        new TestScript();
    }
}

