/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.management.Attribute;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KatelloOrg {
    protected static Logger log = Logger.getLogger(KatelloOrg.class.getName());
    public static final String DEFAULT_ORG = "ACME_Corporation";
    public static final String CLI_CMD_CREATE = "org create";
    public static final String CLI_CMD_INFO = "org info";
    public static final String CLI_CMD_LIST = "org list";
    public static final String CMD_SUBSCRIPTIONS = "org subscriptions";
    public static final String CMD_UEBERCERT = "org uebercert";
    public static final String CMD_DELETE = "org delete";
    public static final String CMD_UPDATE = "org update";
    public static final String API_CMD_INFO = "/organizations/%s";
    public static final String ERR_TEMPLATE_NOTFOUND = "Could not find template [ %s ]";
    public static final String OUT_CREATE = "Successfully created org [ %s ]";
    public static final String ERR_ORG_EXISTS = "Validation failed: Name has already been taken, Label has already been taken";
    public static final String ERR_NAME_INVALID = "Validation failed: Name cannot contain characters other than alpha numerals, space,'_', '-'.";
    public static final String ERR_ORG_NOTFOUND = "Couldn't find organization '%s'";
    public static final String REG_ORG_LIST = ".*Id:\\s+\\d+.*Name:\\s+%s.*Description:\\s+%s.*";
    public static final String REG_ORG_INFO = ".*Id:\\s+\\d+.*Name:\\s+%s.*Description:.*%s.*";
    public static final String OUT_ORG_SUBSCR = "Subscription:   %s";
    public String name;
    public String description;
    private Long id;
    private String cpKey;
    private KatelloCli cli;
    private ArrayList<Attribute> opts;

    public KatelloOrg() {
    }

    public KatelloOrg(String pName, String pDesc) {
        this.name = pName;
        this.description = pDesc;
        this.opts = new ArrayList();
    }

    protected KatelloOrg(Long id, String name, String description) {
        this(name, description);
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="cp_key")
    public String getCpKey() {
        return this.cpKey;
    }

    @JsonProperty(value="cp_key")
    public void setCpKey(String cpKey) {
        this.cpKey = cpKey;
    }

    public SSHCommandResult cli_create() {
        return this.cli_create(null);
    }

    public SSHCommandResult cli_create(KatelloUser user) {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", this.description));
        this.cli = user == null ? new KatelloCli(CLI_CMD_CREATE, this.opts) : new KatelloCli(CLI_CMD_CREATE, this.opts, user);
        return this.cli.run();
    }

    public SSHCommandResult cli_info() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CLI_CMD_INFO, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_list() {
        this.opts.clear();
        KatelloCli cli = new KatelloCli("org list -v", this.opts);
        return cli.run();
    }

    public SSHCommandResult subscriptions() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_SUBSCRIPTIONS, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult uebercert() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_UEBERCERT, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_DELETE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update(String new_description) {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", new_description));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }
}

