/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloPackage;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-cli"})
public class PackageTests
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(PackageTests.class.getName());
    private SSHCommandResult exec_result;
    private String org_name;
    private String user_name;
    private String provider_name;
    private String product_name;
    private String repo_name;
    private String env_name;

    @BeforeClass(description="Generate unique objects")
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.org_name = "org" + uid;
        this.user_name = "user" + uid;
        this.provider_name = "provider" + uid;
        this.product_name = "product" + uid;
        this.repo_name = "repo" + uid;
        this.env_name = "env" + uid;
        KatelloOrg org = new KatelloOrg(this.org_name, "Package tests");
        this.exec_result = org.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloUser user = new KatelloUser(this.user_name, "root@localhost", "testing", false);
        this.exec_result = user.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProvider prov = new KatelloProvider(this.provider_name, this.org_name, "Package provider", "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/x86_64/");
        this.exec_result = prov.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod = new KatelloProduct(this.product_name, this.org_name, this.provider_name, null, null, null, null, null);
        this.exec_result = prod.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloRepo repo = new KatelloRepo(this.repo_name, this.org_name, this.product_name, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/x86_64/", null, null);
        this.exec_result = repo.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloEnvironment env = new KatelloEnvironment(this.env_name, null, this.org_name, "Library");
        this.exec_result = env.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        prov.synchronize();
    }

    @Test(description="package list", groups={"cli-packages"}, enabled=true)
    public void test_packageList() {
        KatelloPackage pack = new KatelloPackage(null, null, this.org_name, this.product_name, this.repo_name, null);
        this.exec_result = pack.cli_list();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("pulp-admin"));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("pulp"));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("python-gofer"));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("python-qpid"));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("pulp-common"));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("pulp-consumer"));
    }

    @Test(description="package search", groups={"cli-packages"}, enabled=true)
    public void test_packageSearch() {
        String id;
        KatelloPackage pack = new KatelloPackage(null, null, this.org_name, this.product_name, this.repo_name, null);
        this.exec_result = pack.cli_search("pulp-common*");
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("pulp-common"), (String)"Check - package name should exist in list result");
        Pattern pattern = Pattern.compile("\\w{8}-\\w{4}-\\w{4}-\\w{4}-\\w{12}");
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result));
        Assert.assertTrue((boolean)matcher.find(), (String)"Check - package Id should exist in list result");
        pack.id = id = matcher.group();
        pack.name = "pulp-common";
        this.assert_packageInfo(pack);
    }

    private void assert_packageInfo(KatelloPackage pack) {
        SSHCommandResult res = pack.cli_info();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains(pack.id), (String)"Check - package Id should exist in list result");
        Assert.assertTrue((boolean)this.getOutput(res).contains(pack.name), (String)"Check - package name should exist in list result");
    }
}

