/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.e2e;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloChangeset;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SCPTools;
import com.redhat.qe.tools.SSHCommandResult;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-e2e"})
public class SystemsReport
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(SystemsReport.class.getName());
    String org;
    private String env_dev;
    private String env_test;

    @BeforeClass(description="Init unique names", alwaysRun=true)
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.env_dev = "Dev-" + uid;
        this.env_test = "Test-" + uid;
        ArrayList<String> orgs = this.getOrgsWithImportedManifest();
        if (orgs.size() == 0) {
            log.info("Seems there is no org with imported stage manifest. Doing it now.");
            SCPTools scp = new SCPTools(System.getProperty("katello.client.hostname", "localhost"), System.getProperty("katello.client.ssh.user", "root"), System.getProperty("katello.client.sshkey.private", ".ssh/id_hudson_dsa"), System.getProperty("katello.client.sshkey.passphrase", "null"));
            Assert.assertTrue((boolean)scp.sendFile("data" + File.separator + "export.zip", "/tmp"), (String)"export.zip sent successfully");
            this.org = "org-manifest-" + uid;
            KatelloOrg org = new KatelloOrg(this.org, null);
            org.cli_create();
            KatelloProvider prov = new KatelloProvider("Red Hat", this.org, null, null);
            SSHCommandResult res = prov.import_manifest("/tmp" + File.separator + "export.zip", new Boolean(true));
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (provider import_manifest)");
            Assert.assertTrue((boolean)this.getOutput(res).contains("Manifest imported"), (String)"Message - (provider import_manifest)");
        } else {
            this.org = orgs.get(0);
            log.info("There is an org having manifest. Using: [" + this.org + "]");
        }
    }

    @Test(description="Promote RHEL Server to both environments", enabled=true)
    public void test_promoteToEnvs() {
        log.info("Enable repo: [Red Hat Enterprise Linux 6 Server RPMs x86_64 6Server]");
        KatelloRepo repo = new KatelloRepo("Red Hat Enterprise Linux 6 Server RPMs x86_64 6Server", this.org, "Red Hat Enterprise Linux Server", null, null, null);
        SSHCommandResult res = repo.enable();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (repo enable)");
        Assert.assertTrue((boolean)this.getOutput(res).contains("enabled."), (String)"Message - (repo enable)");
        KatelloEnvironment env = new KatelloEnvironment(this.env_dev, null, this.org, "Library");
        env.cli_create();
        KatelloChangeset cs = new KatelloChangeset("csDev_" + KatelloUtils.getUniqueID(), this.org, this.env_dev);
        cs.create();
        cs.update_addProduct("Red Hat Enterprise Linux Server");
        res = cs.apply();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset promote)");
        Assert.assertTrue((boolean)this.getOutput(res).endsWith("applied"), (String)"Message - (changeset promote)");
        env = new KatelloEnvironment(this.env_test, null, this.org, this.env_dev);
        env.cli_create();
        cs = new KatelloChangeset("csTest_" + KatelloUtils.getUniqueID(), this.org, this.env_test);
        cs.create();
        cs.update_addProduct("Red Hat Enterprise Linux Server");
        res = cs.apply();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset promote)");
        Assert.assertTrue((boolean)this.getOutput(res).endsWith("applied"), (String)"Message - (changeset promote)");
    }

    @Test(description="Add 2 system to env: Dev and 1 systems to: Test", dependsOnMethods={"test_promoteToEnvs"}, enabled=true)
    public void test_addSystemsToEnvs() {
        String sys = "`hostname`" + KatelloUtils.getUniqueID();
        this.rhsm_clean();
        this.rhsm_register(this.org, this.env_dev, "1-" + sys, true);
        this.rhsm_clean();
        this.rhsm_register(this.org, this.env_test, "2-" + sys, true);
        this.rhsm_clean();
        SSHCommandResult res = this.rhsm_register(this.org, this.env_dev, "3-" + sys, true);
        String subscriptionStatus = KatelloCli.grepCLIOutput("Status", this.getOutput(res).trim());
        Assert.assertTrue((boolean)subscriptionStatus.trim().equals("Not Subscribed"), (String)"Check - system should not be subscribed (3rd registration)");
    }

    @Test(description="Check red systems >= 1", dependsOnMethods={"test_addSystemsToEnvs"}, enabled=true)
    public void test_redSystemsCount() {
        SSHCommandResult res = new KatelloCli("system report --org \"" + this.org + "\" --format csv | grep \",red,\" | wc -l", null).run();
        int redCnt = Integer.parseInt(this.getOutput(res).trim());
        Assert.assertTrue((redCnt >= 1 ? 1 : 0) != 0, (String)"Check - red systems cound >=1");
    }

    @Test(description="Check green systems >= 2", dependsOnMethods={"test_addSystemsToEnvs"}, enabled=true)
    public void test_greenSystemsCount() {
        SSHCommandResult res = new KatelloCli("system report --org \"" + this.org + "\" --format csv | grep \",green,\" | wc -l", null).run();
        int redCnt = Integer.parseInt(this.getOutput(res).trim());
        Assert.assertTrue((redCnt >= 2 ? 1 : 0) != 0, (String)"Check - green systems cound >=2");
    }

    @Test(description="Check report headers - compliance", dependsOnMethods={"test_addSystemsToEnvs"}, enabled=true)
    public void test_reportHeaders_compliance() {
        SSHCommandResult res = new KatelloCli("system report --org " + this.org + " | grep \"| compliance |\" | wc -l", null).run();
        int hdrCnt = Integer.parseInt(this.getOutput(res).trim());
        Assert.assertTrue((hdrCnt == 1 ? 1 : 0) != 0, (String)"Check - header compliance");
        res = new KatelloCli("system report --org " + this.org + " | grep \"| compliant_until |\\|compliant until\" | wc -l", null).run();
        hdrCnt = Integer.parseInt(this.getOutput(res).trim());
        Assert.assertTrue((hdrCnt == 1 ? 1 : 0) != 0, (String)"Check - header compliant_until");
    }

    @AfterTest(description="Cleanup the org - allow others to reuse the manifest", alwaysRun=true)
    public void tearDown() {
        KatelloOrg org = new KatelloOrg(this.org, null);
        SSHCommandResult res = org.delete();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (org delete)");
    }
}

