/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.e2e;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloChangeset;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloPackage;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.base.obj.KatelloSystem;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-e2e"})
public class ChangesetPackageDelete
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(ChangesetPackageDelete.class.getName());
    private String org_name;
    private String env_name;
    private String system_name;
    private String provider_name;
    private String product_name;
    private String repo_name;
    private String chst_name;
    private String delchst_name;
    private String readdchst_name;
    private String package_name1 = "lion";
    SSHCommandResult exec_result;

    @BeforeClass(description="init: create all stuff")
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.org_name = "org" + uid;
        KatelloOrg org = new KatelloOrg(this.org_name, "Package tests");
        this.exec_result = org.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
    }

    @Test(description="Create changeset of deletion type, then add already promoted packages to changeset and promote it, verify that packages does not exist in environment anymore")
    public void test_deletionChangesetRemovePackages() {
        this.setupRepos();
        KatelloUtils.sshOnClient("yum -y erase " + this.package_name1);
        KatelloPackage package1 = new KatelloPackage(null, null, this.org_name, this.product_name, this.repo_name, this.env_name);
        this.exec_result = package1.cli_list();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(this.package_name1));
        KatelloChangeset chst = new KatelloChangeset(this.delchst_name, this.org_name, this.env_name, true);
        this.exec_result = chst.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset create)");
        this.exec_result = chst.update_add_package(this.product_name, this.package_name1);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset update)");
        this.exec_result = chst.apply();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset apply)");
        this.exec_result = package1.cli_list();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertFalse((boolean)this.getOutput(this.exec_result).contains(this.package_name1));
        this.yum_clean();
        this.exec_result = KatelloUtils.sshOnClient("yum -y install " + this.package_name1);
        Assert.assertFalse((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (install package)");
    }

    @Test(description="Create changeset of promotion type, then add already reomved packages to changeset and promote it, verify that packages exist in environment", dependsOnMethods={"test_deletionChangesetRemovePackages"})
    public void test_promoteChangesetReAddPackages() {
        KatelloPackage package1 = new KatelloPackage(null, null, this.org_name, this.product_name, this.repo_name, this.env_name);
        KatelloChangeset chst = new KatelloChangeset(this.readdchst_name, this.org_name, this.env_name);
        this.exec_result = chst.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset create)");
        this.exec_result = chst.update_add_package(this.product_name, this.package_name1);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset update)");
        this.exec_result = chst.apply();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset apply)");
        this.exec_result = package1.cli_list();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(this.package_name1));
        this.yum_clean();
        KatelloUtils.sshOnClient("yum -y erase " + this.package_name1);
        this.exec_result = KatelloUtils.sshOnClient("yum -y install " + this.package_name1);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (install package)");
    }

    private void setupRepos() {
        String uid = KatelloUtils.getUniqueID();
        this.env_name = "env" + uid;
        this.provider_name = "provider" + uid;
        this.product_name = "product" + uid;
        this.repo_name = "repo" + uid;
        this.chst_name = "M\u00f6tleyCr\u00fcechangeset" + uid;
        this.delchst_name = "\u6211\u559c\u6b22\u5403\u997a\u5b50deletion_chst" + uid;
        this.system_name = "system" + uid;
        this.readdchst_name = "readd_chst" + uid;
        KatelloProvider prov = new KatelloProvider(this.provider_name, this.org_name, "Package provider", null);
        this.exec_result = prov.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod = new KatelloProduct(this.product_name, this.org_name, this.provider_name, null, null, null, null, null);
        this.exec_result = prod.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloRepo repo = new KatelloRepo(this.repo_name, this.org_name, this.product_name, "http://inecas.fedorapeople.org/fakerepos/zoo3/", null, null);
        this.exec_result = repo.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloEnvironment env = new KatelloEnvironment(this.env_name, null, this.org_name, "Library");
        this.exec_result = env.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (env create)");
        this.exec_result = prod.promote(this.env_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product promote)");
        this.exec_result = repo.synchronize();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.waitfor_reposync(repo, 1);
        KatelloChangeset cs = new KatelloChangeset(this.chst_name, this.org_name, this.env_name);
        this.exec_result = cs.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset create)");
        this.exec_result = cs.update_add_package(this.product_name, this.package_name1);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset update)");
        this.exec_result = cs.apply();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset apply)");
        this.rhsm_clean();
        KatelloSystem sys = new KatelloSystem(this.system_name, this.org_name, this.env_name);
        this.exec_result = sys.rhsm_registerForce();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = sys.subscriptions_available();
        String poolId1 = KatelloCli.grepCLIOutput("Id", this.getOutput(this.exec_result).trim(), 1);
        this.exec_result = sys.rhsm_subscribe(poolId1);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.yum_clean();
    }
}

