/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloIdCert;
import com.redhat.qe.katello.base.obj.KatelloOwner;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import java.util.Map;
import javax.management.Attribute;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KatelloSystem {
    public static final String RHSM_DEFAULT_USER = "admin";
    public static final String RHSM_DEFAULT_PASS = "admin";
    public static final String CMD_INFO = "system info";
    public static final String CMD_LIST = "system list";
    public static final String CMD_SUBSCRIPTIONS = "system subscriptions";
    public static final String CMD_PACKAGES = "system packages";
    public static final String CMD_REPORT = "system report";
    public static final String RHSM_CREATE = String.format("subscription-manager register --username %s --password %s", "admin", "admin");
    public static final String RHSM_CLEAN = "subscription-manager clean";
    public static final String RHSM_SUBSCRIBE = "subscription-manager subscribe";
    public static final String RHSM_UNSUBSCRIBE = "subscription-manager unsubscribe";
    public static final String RHSM_IDENTITY = "subscription-manager identity";
    public static final String RHSM_REGISTER_BYKEY = "subscription-manager register ";
    public static final String OUT_CREATE = "The system has been registered with id:";
    public static final String ERR_RHSM_LOCKER_ONLY = "Organization %s has '%s' environment only. Please create an environment for system registration.";
    public static final String ERR_RHSM_REG_ALREADY_FORCE_NEEDED = "This system is already registered. Use --force to override";
    public static final String ERR_RHSM_REG_MULTI_ENV = "Organization %s has more than one environment. Please specify target environment for system registration.";
    public static final String OUT_REMOTE_ACTION_DONE = "Remote action finished:";
    public static final String OUT_RHSM_SUBSCRIBED_OK = "Successfully subscribed the system";
    public static final String API_CMD_INFO = "/consumers/%s";
    public static final String API_CMD_GET_SERIALS = "/consumers/%s/certificates/serials";
    public static final String REG_SUBSCRIPTION = "Subscription Name:\\s+%s\\s+SKU:\\s+\\w{5,15}+\\s+Pool Id:\\s+\\w{32}+\\s+Quantity:\\s+%s";
    public static final String REG_SUBSCRIPTION_CFSE = "ProductName:\\s+%s\\s+ProductId:\\s+\\w{5,15}\\s+PoolId:\\s+\\w{32}+\\s+Quantity:\\s+%s";
    public static final String REG_POOL_ID = "\\s+\\w{32}+\\s+";
    public String name;
    private String org;
    private String env;
    public String uuid;
    private String href;
    private Long environmentId;
    private KatelloOwner owner;
    private Map<String, String> facts;
    private KatelloIdCert idCert;
    private KatelloEnvironment environment;
    private KatelloCli cli;
    private ArrayList<Attribute> opts;

    public KatelloSystem() {
    }

    public KatelloSystem(String pName, String pOrg, String pEnv) {
        this.name = pName;
        this.org = pOrg;
        this.env = pEnv;
        this.opts = new ArrayList();
    }

    public KatelloSystem(String name, String org, String env, String uuid, Long environmentId, String href, KatelloOwner owner, Map<String, String> facts, KatelloIdCert idCert) {
        this(name, org, env);
        this.uuid = uuid;
        this.environmentId = environmentId;
        this.owner = owner;
        this.href = href;
        this.facts = facts;
        this.idCert = idCert;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="organization")
    public String getOrganization() {
        return this.org;
    }

    @JsonProperty(value="organization")
    public void setOrganization(String org) {
        this.org = org;
    }

    @JsonProperty(value="environment")
    public KatelloEnvironment getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="environment")
    public void setEnvironment(KatelloEnvironment environment) {
        this.environment = environment;
    }

    @JsonProperty(value="environment_id")
    public Long getEnvironmentId() {
        if (this.environment != null && this.environmentId == null) {
            this.environmentId = this.environment.getId();
        }
        return this.environmentId;
    }

    @JsonProperty(value="environment_id")
    public void setEnvironmentId(Long environmentId) {
        this.environmentId = environmentId;
    }

    @JsonProperty(value="uuid")
    public String getUuid() {
        return this.uuid;
    }

    @JsonProperty(value="uuid")
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public KatelloOwner getOwner() {
        return this.owner;
    }

    public void setOwner(KatelloOwner owner) {
        this.owner = owner;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public Map<String, String> getFacts() {
        return this.facts;
    }

    public void setFacts(Map<String, String> facts) {
        this.facts = facts;
    }

    @JsonProperty(value="idCert")
    public KatelloIdCert getIdCert() {
        return this.idCert;
    }

    @JsonProperty(value="idCert")
    public void setIdCert(KatelloIdCert idCert) {
        this.idCert = idCert;
    }

    public SSHCommandResult rhsm_register() {
        String cmd = RHSM_CREATE;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.env != null) {
            cmd = cmd + " --environment \"" + this.env + "\"";
        }
        return KatelloUtils.sshOnClient(cmd);
    }

    public SSHCommandResult rhsm_registerForce() {
        String cmd = RHSM_CREATE;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.env != null) {
            cmd = cmd + " --environment \"" + this.env + "\"";
        }
        cmd = cmd + " --force";
        return KatelloUtils.sshOnClient(cmd);
    }

    public SSHCommandResult rhsm_registerForce(String activationkey) {
        String cmd = RHSM_REGISTER_BYKEY;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (activationkey != null) {
            cmd = cmd + " --activationkey \"" + activationkey + "\"";
        }
        cmd = cmd + " --force";
        return KatelloUtils.sshOnClient(cmd);
    }

    public SSHCommandResult rhsm_clean() {
        String cmd = RHSM_CLEAN;
        return KatelloUtils.sshOnClient(cmd);
    }

    public SSHCommandResult list() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("environment", this.env));
        this.cli = new KatelloCli("system list -v", this.opts);
        return this.cli.run();
    }

    public SSHCommandResult report() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("environment", this.env));
        this.cli = new KatelloCli("system report -v", this.opts);
        return this.cli.run();
    }

    public SSHCommandResult subscriptions_available() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli("system subscriptions --available -v", this.opts);
        return this.cli.run();
    }

    public SSHCommandResult subscriptions() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_SUBSCRIPTIONS, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult subscriptions_count() {
        String cmd = CMD_SUBSCRIPTIONS;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        cmd = cmd + " | grep \"Serial Id\" | wc -l";
        this.cli = new KatelloCli(cmd, null);
        return this.cli.run();
    }

    public SSHCommandResult packages_install(String packageName) {
        this.opts.clear();
        this.opts.add(new Attribute("install", packageName));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_PACKAGES, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult rhsm_subscribe(String poolid) {
        String cmd = RHSM_SUBSCRIBE;
        if (poolid != null) {
            cmd = cmd + " --pool " + poolid;
        }
        return KatelloUtils.sshOnClient(cmd);
    }

    public SSHCommandResult rhsm_unsubscribe(String serialId) {
        String cmd = RHSM_UNSUBSCRIBE;
        if (serialId != null) {
            cmd = cmd + " --serial " + serialId;
        }
        return KatelloUtils.sshOnClient(cmd);
    }

    public SSHCommandResult rhsm_subscribe(String poolid, int quantity) {
        String cmd = RHSM_SUBSCRIBE;
        if (poolid != null) {
            cmd = cmd + " --pool " + poolid;
        }
        if (quantity != 0) {
            cmd = cmd + " --quantity " + quantity;
        }
        return KatelloUtils.sshOnClient(cmd);
    }

    public SSHCommandResult rhsm_subscribe_auto() {
        String cmd = "subscription-manager subscribe --auto";
        return KatelloUtils.sshOnClient(cmd);
    }

    public SSHCommandResult rhsm_identity() {
        String cmd = RHSM_IDENTITY;
        return KatelloUtils.sshOnClient(cmd);
    }
}

