/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import javax.management.Attribute;

public class KatelloSystemGroup {
    public String name;
    public String org;
    public String description;
    public int totalSystems = 0;
    public Integer maxSystems;
    private KatelloCli cli;
    private ArrayList<Attribute> opts;
    public static final String CMD_CREATE = "system_group create";
    public static final String CMD_INFO = "system_group info";
    public static final String CMD_LIST = "system_group list";
    public static final String CMD_LIST_SYSTEMS = "system_group systems";
    public static final String CMD_DELETE = "system_group delete";
    public static final String CMD_UPDATE = "system_group update";
    public static final String CMD_COPY = "system_group copy";
    public static final String CMD_ADD_SYSTEMS = "system_group add_systems";
    public static final String CMD_REMOVE_SYSTEMS = "system_group remove_systems";
    public static final String OUT_CREATE = "Successfully created system group [ %s ]";
    public static final String OUT_COPY = "Successfully copied system group [ %s ] to [ %s ]";
    public static final String OUT_ADD_SYSTEMS = "Successfully added systems to system group [ %s ]";
    public static final String OUT_REMOVE_SYSTEMS = "Successfully removed systems from system group [ %s ]";
    public static final String ERR_SYSTEMGROUP_NOTFOUND = "Could not find system group [ %s ] within organization [ %s ]";
    public static final String ERR_SYSTEMGROUP_EXCEED = "Validation failed: You cannot have more than %s system(s) associated with system group '%s'.";
    public static final String REG_SYSTEMGROUP_INFO = ".*Id:\\s+\\d+.*Name:\\s+%s.*Description:\\s+%s.*Total Systems:\\s+%s.*";
    public static final String REG_SYSTEMGROUP_LIST = ".*\\s+\\d+.*\\s+%s.*";
    public static final String REG_SYSTEM_LIST = ".*\\s+%s.*\\s+%s.*";

    public KatelloSystemGroup(String pName, String pOrg) {
        this(pName, pOrg, null, null);
    }

    public KatelloSystemGroup(String pName, String pOrg, String pDescription, Integer pmaxSystems) {
        this.name = pName;
        this.org = pOrg;
        this.description = pDescription;
        this.maxSystems = pmaxSystems;
        this.opts = new ArrayList();
    }

    public SSHCommandResult create() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", this.description));
        this.opts.add(new Attribute("max_systems", this.maxSystems));
        this.cli = new KatelloCli(CMD_CREATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult info() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_INFO, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update(String newname, String newdescr, Integer newmaxSystems) {
        this.opts.clear();
        this.opts.add(new Attribute("new_name", newname));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", newdescr));
        this.opts.add(new Attribute("max_systems", newmaxSystems));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult copy(String newname, String newdescr, Integer newmaxSystems) {
        this.opts.clear();
        this.opts.add(new Attribute("new_name", newname));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", newdescr));
        this.opts.add(new Attribute("max_systems", newmaxSystems));
        this.cli = new KatelloCli(CMD_COPY, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult add_systems(String system_uuids) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("system_uuids", system_uuids));
        this.cli = new KatelloCli(CMD_ADD_SYSTEMS, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult remove_systems(String system_uuids) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("system_uuids", system_uuids));
        this.cli = new KatelloCli(CMD_REMOVE_SYSTEMS, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult list() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.cli = new KatelloCli(CMD_LIST, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult list_systems() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_LIST_SYSTEMS, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_DELETE, this.opts);
        return this.cli.run();
    }
}

