/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import javax.management.Attribute;

public class KatelloUserRole {
    public static final String CMD_CREATE = "user_role create";
    public static final String OUT_CREATE = "Successfully created user role [ %s ]";
    public static final String CMD_INFO = "user_role info -v";
    public static final String CLI_CMD_LIST = "user_role list -v";
    public static final String CMD_UPDATE = "user_role update";
    public static final String CMD_DELETE = "user_role delete";
    public static final String CMD_LDAP_GRP_ADD = "user_role add_ldap_group";
    public static final String CMD_LDAP_GRP_REMOVE = "user_role remove_ldap_group";
    public static final String ERROR_INFO = "Cannot find user role [ %s ]";
    public static final String OUT_UPDATE = "Successfully updated user role [ %s ]";
    public static final String OUT_DELETE = "Successfully deleted user role [ %s ]";
    public static final String OUT_LDAP_ADD = "Successfully added LDAP group [ %s ] to the user role [ %s ]";
    public static final String OUT_LDAP_REMOVE = "Successfully removed LDAP group [ %s ] from the user role [ %s ]";
    public String name;
    public String description;
    private KatelloCli cli;
    private ArrayList<Attribute> opts;

    public KatelloUserRole(String pName, String pDesc) {
        this.name = pName;
        this.description = pDesc;
        this.opts = new ArrayList();
    }

    public SSHCommandResult create() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", this.description));
        this.cli = new KatelloCli(CMD_CREATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_info() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_INFO, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_list() {
        this.opts.clear();
        this.cli = new KatelloCli(CLI_CMD_LIST, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_update(String new_name) {
        this.opts.clear();
        this.opts.add(new Attribute("new_name", new_name));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", this.description));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_delete() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_DELETE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_add_ldap_group(String group_name) {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("group_name", group_name));
        this.cli = new KatelloCli(CMD_LDAP_GRP_ADD, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_remove_ldap_group(String group_name) {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("group_name", group_name));
        this.cli = new KatelloCli(CMD_LDAP_GRP_REMOVE, this.opts);
        return this.cli.run();
    }
}

