/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.common;

import com.redhat.qe.tools.ExecCommands;
import com.redhat.qe.tools.SSHCommandResult;
import com.redhat.qe.tools.SSHCommandRunner;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KatelloUtils {
    private static Logger log = Logger.getLogger(KatelloUtils.class.getName());
    private static Boolean isClientLocalhost = null;
    private static Boolean isServerLocalhost = null;

    public static void waitfor_katello() {
        KatelloUtils.sshOnServer("python -c \"from katello.utils import waitfor_katello; waitfor_katello()\"");
    }

    public static String run_local(String command) {
        return KatelloUtils.run_local(false, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String run_local(boolean showLogResults, String command) {
        String out = null;
        String tmp_cmdFile = "/tmp/katello-" + KatelloUtils.getUniqueID() + ".sh";
        ExecCommands localRunner = new ExecCommands();
        try {
            localRunner.submitCommandToLocalWithReturn(false, "rm -f " + tmp_cmdFile, "");
            FileOutputStream fout = new FileOutputStream(tmp_cmdFile);
            fout.write((command + "\n").getBytes());
            fout.flush();
            fout.close();
            log.finest(String.format("Executing local: [%s]", command));
            out = localRunner.submitCommandToLocalWithReturn(false, "/bin/bash " + tmp_cmdFile, "");
            if (showLogResults) {
                String[] split = out.split("\\n");
                for (int i = 0; i < split.length; ++i) {
                    log.info("Output: " + split[i]);
                }
            }
        }
        catch (IOException iex) {
            log.log(Level.SEVERE, iex.getMessage(), iex);
        }
        finally {
            try {
                localRunner.submitCommandToLocalWithReturn(false, "rm -f " + tmp_cmdFile, "");
            }
            catch (IOException ie) {
                log.log(Level.SEVERE, ie.getMessage(), ie);
            }
        }
        return out;
    }

    public static String getUniqueID() {
        try {
            Thread.sleep(1000 + Math.abs(new Random().nextInt(200)));
        }
        catch (InterruptedException iex) {
            // empty catch block
        }
        String uid = String.valueOf(Calendar.getInstance().getTimeInMillis() / 1000L);
        log.fine(String.format("Generating unique ID: [%s]", uid));
        return uid;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static long getDiskFreeForPulpRepos() {
        long dfPulpRepos = Long.MAX_VALUE;
        String res = KatelloUtils.sshOnServer("df `grep \"Alias /pulp/repos\" /etc/httpd/conf.d/pulp.conf | awk '{print $3}'` | tail -1 | awk '{print $3}'").getStdout().trim();
        log.fine("Free disk space for Pulp repositories: [" + res + "]");
        dfPulpRepos = new Long(res);
        return dfPulpRepos;
    }

    public static SSHCommandResult sshOnClient(String _cmd) {
        try {
            SSHCommandRunner ssh_client = new SSHCommandRunner(System.getProperty("katello.client.hostname", "localhost"), "root", System.getProperty("katello.client.ssh.passphrase", "secret"), System.getProperty("katello.client.sshkey.private", ".ssh/id_dsa"), System.getProperty("katello.client.sshkey.passphrase", "secret"), null);
            return ssh_client.runCommandAndWait(_cmd);
        }
        catch (Throwable t) {
            log.warning("Warning: Could not initialize client's SSHCommandRunner.");
            log.warning("Warning: " + t.getMessage());
            t.printStackTrace();
            return null;
        }
    }

    public static SSHCommandResult sshOnServer(String _cmd) {
        try {
            SSHCommandRunner ssh_server = new SSHCommandRunner(System.getProperty("katello.server.hostname", "localhost"), "root", System.getProperty("katello.server.ssh.passphrase", "secret"), System.getProperty("katello.server.sshkey.private", ".ssh/id_dsa"), System.getProperty("katello.server.sshkey.passphrase", "secret"), null);
            return ssh_server.runCommandAndWait(_cmd);
        }
        catch (Throwable t) {
            log.warning("Warning: Could not initialize server's SSHCommandRunner.");
            log.warning("Warning: " + t.getMessage());
            t.printStackTrace();
            return null;
        }
    }

    public static SSHCommandResult stopKatello() {
        String _cmd = "service katello-jobs stop; service katello stop; service pulp-server stop; service tomcat6 stop; service elasticsearch stop;";
        return KatelloUtils.sshOnServer(_cmd);
    }

    public static SSHCommandResult startKatello() {
        String _cmd = "service elasticsearch start; service tomcat6 start; service pulp-server start; service katello start; service katello-jobs start;";
        return KatelloUtils.sshOnServer(_cmd);
    }
}

