/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliDataProvider;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.testng.annotations.Test;

public class OrgTests
extends KatelloCliTestScript {
    List<KatelloOrg> orgs;

    @Test(description="List all orgs - ACME_Corporation should be there", groups={"cfse-cli", "headpin-cli"})
    public void test_listOrgs_ACME_Corp() {
        KatelloOrg list_org = new KatelloOrg(null, null);
        SSHCommandResult res = list_org.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains("ACME_Corporation"), (String)"Check - contains: [ACME_Corporation]");
    }

    @Test(description="Create org - different variations", dataProviderClass=KatelloCliDataProvider.class, dataProvider="org_create", groups={"cfse-cli", "headpin-cli"})
    public void test_createOrg(String name, String descr) {
        KatelloOrg org = new KatelloOrg(name, descr);
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        if (this.orgs == null) {
            this.orgs = Collections.synchronizedList(new ArrayList());
        }
        this.orgs.add(org);
    }

    @Test(description="List orgs - created", dependsOnMethods={"test_createOrg"}, groups={"cfse-cli", "headpin-cli"})
    public void test_infoListOrg() {
        String uniqueID = KatelloUtils.getUniqueID();
        KatelloOrg list_org = new KatelloOrg("orgUpd" + uniqueID, "Simple description");
        list_org.cli_create();
        this.orgs.add(list_org);
        list_org = new KatelloOrg(null, null);
        SSHCommandResult res = list_org.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (org list)");
        for (KatelloOrg org : this.orgs) {
            if (org.description == null) {
                org.description = "None";
            }
            String match_list = String.format(".*Id:\\s+\\d+.*Name:\\s+%s.*Description:\\s+%s.*", org.name, org.description).replaceAll("\"", "");
            Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_list), (String)("Check - org matches [" + org.name + "]"));
            this.assert_orgInfo(org);
        }
    }

    @Test(description="Update org's description", groups={"cfse-cli", "headpin-cli"})
    public void test_updateOrg() {
        String uniqueID = KatelloUtils.getUniqueID();
        KatelloOrg org = new KatelloOrg("orgUpd" + uniqueID, "Simple description");
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String new_desc = String.format("Updated %s", org.description);
        res = org.update(new_desc);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)String.format("Successfully updated org [ %s ]", org.name));
        org.description = "\u60a8\u597d" + org.description;
        res = org.update(org.description);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)String.format("Successfully updated org [ %s ]", org.name));
        res = org.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (org list)");
        this.assert_orgInfo(org);
    }

    @Test(description="Delete an organization", groups={"cfse-cli", "headpin-cli"})
    public void test_deleteOrg() {
        String uniqueID = KatelloUtils.getUniqueID();
        KatelloOrg org = new KatelloOrg("orgDel" + uniqueID, null);
        org.cli_create();
        SSHCommandResult res = org.delete();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully deleted org [ %s ]", org.name)), (String)"Check - return string");
        res = org.cli_info();
        Assert.assertTrue((res.getExitCode() == 148 ? 1 : 0) != 0, (String)"Check - return code [148]");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)String.format("Couldn't find organization '%s'", org.name));
    }

    @Test(description="Delete an organization which does not exist", groups={"cfse-cli", "headpin-cli"})
    public void test_deleteOrgNotExist() {
        String uniqueID = KatelloUtils.getUniqueID();
        KatelloOrg org = new KatelloOrg("orgDel" + uniqueID, null);
        SSHCommandResult res = org.delete();
        Assert.assertTrue((res.getExitCode() == 148 ? 1 : 0) != 0, (String)"Check - return code [148]");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)String.format("Couldn't find organization '%s'", org.name));
    }

    @Test(description="List org subscriptions.", groups={"cfse-cli"})
    public void test_orgSubscriptions() {
        String uniqueID = KatelloUtils.getUniqueID();
        String orgName = "subscriptions-" + uniqueID;
        KatelloOrg org = new KatelloOrg(orgName, null);
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (org create)");
        String providerName = "provider" + uniqueID;
        KatelloProvider prov = new KatelloProvider(providerName, orgName, "Fedora provider", null);
        res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String productName = "product" + uniqueID;
        KatelloProduct prod = new KatelloProduct(productName, orgName, providerName, null, null, null, null, null);
        res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String productName1 = "product1" + uniqueID;
        prod = new KatelloProduct(productName1, orgName, providerName, null, null, null, null, null);
        res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.waitfor_orgsubscriptions(org, 1);
        res = org.subscriptions();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (org subscriptions)");
        Assert.assertTrue((boolean)this.getOutput(res).trim().contains(String.format("Subscription:   %s", productName)), (String)("Check - Subscriptions contains " + productName));
        Assert.assertTrue((boolean)this.getOutput(res).trim().contains(String.format("Subscription:   %s", productName1)), (String)("Check - Subscriptions contains " + productName1));
    }

    @Test(description="Create org - existing", groups={"cfse-cli", "headpin-cli"})
    public void test_createOrgExists() {
        String uniqueID = KatelloUtils.getUniqueID();
        KatelloOrg org = new KatelloOrg("orgCrt" + uniqueID, "Simple description");
        org.cli_create();
        KatelloOrg org2 = new KatelloOrg("orgCrt" + uniqueID, "Simple description");
        SSHCommandResult res = org2.cli_create();
        Assert.assertTrue((res.getExitCode() == 144 ? 1 : 0) != 0, (String)"Check - return code [144]");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)"Validation failed: Name has already been taken, Label has already been taken");
    }

    @Test(description="Create org - name is invalid", groups={"cfse-cli", "headpin-cli"})
    public void test_createOrgInvalidName() {
        String uniqueID = KatelloUtils.getUniqueID();
        KatelloOrg org = new KatelloOrg("orgCrt" + uniqueID + " very ++== invalid name", "Simple description");
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 144 ? 1 : 0) != 0, (String)"Check - return code [144]");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)"Validation failed: Label is invalid, Label cannot contain characters other than ascii alpha numerals, '_', '-'. , Name cannot contain characters other than alpha numerals, space,'_', '-'.");
    }

    private void assert_orgInfo(KatelloOrg org) {
        SSHCommandResult res = org.cli_info();
        String match_info = String.format(".*Id:\\s+\\d+.*Name:\\s+%s.*Description:.*%s.*", org.name, org.description).replaceAll("\"", "");
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        log.finest(String.format("Org (info) match regex: [%s]", match_info));
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Org [%s] should be found in the result info", org.name));
    }
}

