/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloFilter;
import com.redhat.qe.katello.base.obj.KatelloGpgKey;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.katello.tests.cli.PackageTests;
import com.redhat.qe.tools.SSHCommandResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-cli"})
public class RepoTests
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(PackageTests.class.getName());
    private SSHCommandResult exec_result;
    private String org_name;
    private String user_name;
    private String provider_name;
    private String product_name;
    private String repo_name;
    private String gpg_key;
    private String file_name;
    private String filter_name;
    private String filter_name2;
    private KatelloFilter filter1;
    private KatelloFilter filter2;

    @BeforeClass(description="Generate unique objects")
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.org_name = "org" + uid;
        this.user_name = "user" + uid;
        this.provider_name = "provider" + uid;
        this.product_name = "product" + uid;
        this.file_name = "/tmp/RPM-GPG-KEY-dummy-packages-generator";
        this.gpg_key = "gpgkey-" + uid;
        KatelloOrg org = new KatelloOrg(this.org_name, "Package tests");
        this.exec_result = org.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloUser user = new KatelloUser(this.user_name, "root@localhost", "testing", false);
        this.exec_result = user.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProvider prov = new KatelloProvider(this.provider_name, this.org_name, "Package provider", "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/6Server/x86_64/");
        this.exec_result = prov.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod = new KatelloProduct(this.product_name, this.org_name, this.provider_name, null, null, null, null, null);
        this.exec_result = prod.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String cmd = "rm -f " + this.file_name + "; " + "curl -sk " + "http://inecas.fedorapeople.org/fakerepos/zoo/RPM-GPG-KEY-dummy-packages-generator" + " -o " + this.file_name;
        this.exec_result = KatelloUtils.sshOnClient(cmd);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (get gpg file)");
        KatelloGpgKey gpg = new KatelloGpgKey(this.gpg_key, this.org_name, this.file_name);
        this.exec_result = gpg.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.filter_name = "filter" + uid;
        this.filter1 = new KatelloFilter(this.filter_name, this.org_name, null, null);
        this.exec_result = this.filter1.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (filter create)");
        this.filter_name2 = "filter2" + uid;
        this.filter2 = new KatelloFilter(this.filter_name2, this.org_name, null, null);
        this.exec_result = this.filter2.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (filter create)");
    }

    @Test(description="Create repo", groups={"cli-repo"})
    public void test_createRepo() {
        KatelloRepo repo = this.createRepo();
        this.assert_repoInfo(repo);
        this.assert_repoStatus(repo);
    }

    @Test(description="Create repo exists", groups={"cli-repo"})
    public void test_createRepoExists() {
        KatelloRepo repo = this.createRepo();
        this.exec_result = repo.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 153 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("There is already a repo with the name [ %s ] for product [ %s ]", repo.name, repo.product));
    }

    @Test(description="Discover repo", groups={"cli-repo"})
    public void test_discoverRepo() {
        this.repo_name = "repo" + KatelloUtils.getUniqueID();
        String url_name = "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/6Server/x86_64/".replace("http://repos.fedorapeople.org", "").replace("/", "_");
        url_name = url_name.substring(0, url_name.length() - 1);
        KatelloRepo repo = new KatelloRepo(this.repo_name, this.org_name, this.product_name, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/6Server/x86_64/", null, null);
        this.exec_result = repo.discover();
        repo.name = this.repo_name = this.repo_name + url_name;
        repo.url = repo.url.substring(0, repo.url.length() - 1);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully created repository [ %s ]", this.repo_name)), (String)"Check - output string (repo discover)");
        this.assert_repoInfo(repo);
        this.assert_repoStatus(repo);
    }

    @Test(description="List repos", groups={"cli-repo"})
    public void test_listRepo() {
        KatelloRepo repo = this.createRepo();
        String repoName1 = this.repo_name + "1";
        KatelloRepo repo1 = new KatelloRepo(repoName1, this.org_name, this.product_name, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/6Server/x86_64/", null, null);
        this.exec_result = repo1.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = repo1.list();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.assert_repoList(this.getOutput(this.exec_result).replaceAll("\n", " "), repo);
        this.assert_repoList(this.getOutput(this.exec_result).replaceAll("\n", " "), repo1);
    }

    @Test(description="Update repo gpg key", groups={"cli-repo"})
    public void test_updateRepo() {
        KatelloRepo repo = this.createRepo();
        repo.gpgkey = this.gpg_key;
        repo.update_gpgkey();
        this.assert_repoInfo(repo);
        this.assert_repoStatus(repo);
    }

    @Test(description="Synchronize repository", groups={"cli-repo"})
    public void test_syncRepo() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        KatelloRepo repo = this.createRepo();
        this.exec_result = repo.synchronize();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).trim().contains(String.format("Repo [ %s ] synced", repo.name)));
        this.exec_result = repo.status();
        Pattern pattern = Pattern.compile("\\d{4}/\\d{2}/\\d{2}\\s\\d{2}:\\d{2}:\\d{2}");
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result));
        Assert.assertTrue((boolean)matcher.find(), (String)"Check - last sync date should exist in repo status");
        String dateString = matcher.group();
        try {
            format.parse(dateString);
        }
        catch (ParseException e) {
            Assert.fail((String)"Invalid date is returned");
        }
        repo.progress = "Finished";
        repo.lastSync = dateString;
        this.assert_repoInfo(repo);
        this.assert_repoStatus(repo);
        this.exec_result = repo.list();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.assert_repoList(this.getOutput(this.exec_result).replaceAll("\n", " "), repo);
    }

    @Test(description="Try to enable/disable custom repo, check error", groups={"cli-repo"})
    public void test_enableDisableRepo() {
        KatelloRepo repo = this.createRepo();
        this.exec_result = repo.enable();
        Assert.assertTrue((this.exec_result.getExitCode() == 148 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)"Disable/enable is not supported for custom repositories.");
        this.exec_result = repo.disable();
        Assert.assertTrue((this.exec_result.getExitCode() == 148 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)"Disable/enable is not supported for custom repositories.");
    }

    @Test(description="Delete repo", groups={"cli-repo"})
    public void test_deleteRepo() {
        KatelloRepo repo = this.createRepo();
        repo.delete();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = repo.info();
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Could not find repository [ %s ] within organization [ %s ], product [ %s ] and environment [ %s ]", repo.name, repo.org, repo.product, "Library"));
    }

    @Test(description="Add filter to repo", groups={"cli-repo"})
    public void test_addFilter() {
        KatelloRepo repo = this.createRepo();
        this.exec_result = repo.add_filter(this.filter_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Added filter [ %s ] to repository [ %s ]", this.filter_name, repo.name));
        this.assert_repoFilterList(repo, Arrays.asList(this.filter1), new ArrayList<KatelloFilter>());
    }

    @Test(description="Remove filter from repo", groups={"cli-repo"})
    public void test_removeFilter() {
        KatelloRepo repo = this.createRepo();
        this.exec_result = repo.add_filter(this.filter_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = repo.add_filter(this.filter_name2);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.assert_repoFilterList(repo, Arrays.asList(this.filter1, this.filter2), new ArrayList<KatelloFilter>());
        repo.remove_filter(this.filter_name);
        this.assert_repoFilterList(repo, Arrays.asList(this.filter2), Arrays.asList(this.filter1));
    }

    @Test(description="Call commands on non existing repo", groups={"cli-repo"})
    public void test_commandsInvalidRepo() {
        this.repo_name = "repo" + KatelloUtils.getUniqueID();
        KatelloRepo repo = new KatelloRepo(this.repo_name, this.org_name, this.product_name, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/6Server/x86_64/", null, null);
        this.exec_result = repo.add_filter(this.filter_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Could not find repository [ %s ] within organization [ %s ], product [ %s ] and environment [ %s ]", repo.name, repo.org, repo.product, "Library"));
        this.exec_result = repo.remove_filter(this.filter_name2);
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Could not find repository [ %s ] within organization [ %s ], product [ %s ] and environment [ %s ]", repo.name, repo.org, repo.product, "Library"));
        this.exec_result = repo.disable();
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Could not find repository [ %s ] within organization [ %s ], product [ %s ] and environment [ %s ]", repo.name, repo.org, repo.product, "Library"));
        this.exec_result = repo.enable();
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Could not find repository [ %s ] within organization [ %s ], product [ %s ] and environment [ %s ]", repo.name, repo.org, repo.product, "Library"));
        this.exec_result = repo.info();
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Could not find repository [ %s ] within organization [ %s ], product [ %s ] and environment [ %s ]", repo.name, repo.org, repo.product, "Library"));
        this.exec_result = repo.synchronize();
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Could not find repository [ %s ] within organization [ %s ], product [ %s ] and environment [ %s ]", repo.name, repo.org, repo.product, "Library"));
        repo.gpgkey = this.gpg_key;
        this.exec_result = repo.update_gpgkey();
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Could not find repository [ %s ] within organization [ %s ], product [ %s ] and environment [ %s ]", repo.name, repo.org, repo.product, "Library"));
    }

    private void assert_repoInfo(KatelloRepo repo) {
        if (repo.gpgkey == null) {
            repo.gpgkey = "";
        }
        if (repo.progress == null) {
            repo.progress = "Not synced";
        }
        if (repo.lastSync == null) {
            repo.lastSync = "never";
        }
        SSHCommandResult res = repo.info();
        String match_info = String.format(".*Id:\\s+\\d+.*Name:\\s+%s.*Url:\\s+%s.*Last Sync:\\s+%s.*Progress:\\s+%s.*GPG key:\\s*+%s.*", repo.name, repo.url, repo.lastSync, repo.progress, repo.gpgkey).replaceAll("\"", "");
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        log.finest(String.format("Repo (info) match regex: [%s]", match_info));
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", " ").matches(match_info), (String)String.format("Repo [%s] should be found in the result info", repo.name));
    }

    private void assert_repoStatus(KatelloRepo repo) {
        if (repo.progress == null) {
            repo.progress = "Not synced";
        }
        if (repo.lastSync == null) {
            repo.lastSync = "never";
        }
        SSHCommandResult res = repo.status();
        String match_info = String.format(".*Package Count:\\s+\\d+.*Last Sync:\\s+%s.*Sync State:\\s+%s.*", repo.lastSync, repo.progress).replaceAll("\"", "");
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        log.finest(String.format("Repo (status) match regex: [%s]", match_info));
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Repo [%s] should be found in the result", repo.name));
    }

    private void assert_repoFilterList(KatelloRepo repo, List<KatelloFilter> filters, List<KatelloFilter> excludeFilters) {
        String match_list;
        SSHCommandResult res = repo.list_filters();
        for (KatelloFilter flt : filters) {
            if (flt.description == null) {
                flt.description = "None";
            }
            match_list = String.format(".*\\s+%s.*\\s+%s", flt.name, flt.description).replaceAll("\"", "");
            Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_list), (String)("Check - filter matches [" + flt.name + "]"));
        }
        for (KatelloFilter flt : excludeFilters) {
            if (flt.description == null) {
                flt.description = "None";
            }
            match_list = String.format(".*\\s+%s.*\\s+%s", flt.name, flt.description).replaceAll("\"", "");
            Assert.assertFalse((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_list), (String)("Check - filter not matches [" + flt.name + "]"));
        }
    }

    private void assert_repoList(String result, KatelloRepo repo) {
        if (repo.lastSync == null) {
            repo.lastSync = "never";
        }
        String match_info = String.format(".*Id:\\s+\\d+.*Name:\\s+%s.*Package Count:\\s+\\d+.*Last Sync:\\s+%s.*", repo.name, repo.lastSync).replaceAll("\"", "");
        Assert.assertTrue((boolean)result.matches(match_info), (String)String.format("Repo [%s] should be found in the result list", repo.name));
    }

    private KatelloRepo createRepo() {
        this.repo_name = "repo" + KatelloUtils.getUniqueID();
        KatelloRepo repo = new KatelloRepo(this.repo_name, this.org_name, this.product_name, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/6Server/x86_64/", null, null);
        this.exec_result = repo.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).equals(String.format("Successfully created repository [ %s ]", this.repo_name)), (String)"Check - output string (repo create)");
        return repo;
    }
}

