/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloSystem;
import com.redhat.qe.katello.base.obj.KatelloSystemGroup;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-cli", "headpin-cli"})
public class SystemGroupTests
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(SystemGroupTests.class.getName());
    private SSHCommandResult exec_result;
    private String orgName;
    private String systemGroupName;
    private String envName;
    private String systemName;
    private String system_uuid;

    @BeforeClass(description="Generate unique names")
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.orgName = "org-" + uid;
        this.envName = "Dev-" + uid;
        KatelloOrg org = new KatelloOrg(this.orgName, null);
        this.exec_result = org.cli_create();
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code (org create)");
        Assert.assertTrue((boolean)this.exec_result.getStdout().trim().equals(String.format("Successfully created org [ %s ]", this.orgName)), (String)"Check - returned message");
        KatelloEnvironment env = new KatelloEnvironment(this.envName, null, this.orgName, "Library");
        this.exec_result = env.cli_create();
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code (env create)");
        KatelloUtils.sshOnClient("subscription-manager clean");
    }

    @Test(description="Create system group", groups={"cli-systemgroup"})
    public void test_createSystemGroup() {
        KatelloSystemGroup systemGroup = this.createSystemGroup();
        this.assert_SystemGroupInfo(systemGroup);
    }

    @Test(description="Create system group which already exists, verify error", groups={"cli-systemgroup"})
    public void test_createSystemGroupExists() {
        KatelloSystemGroup systemGroup = this.createSystemGroup();
        this.exec_result = systemGroup.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 144 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)"Validation failed: Name must be unique within one organization");
    }

    @Test(description="Create system group, than update it's name, description and max systems", groups={"cli-systemgroup"})
    public void test_updateSystemGroup() {
        KatelloSystemGroup systemGroup = this.createSystemGroup();
        String oldName = systemGroup.name;
        String newName = systemGroup.name + "new";
        String newdescr = "new description";
        this.exec_result = systemGroup.update(newName, newdescr, 1);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        systemGroup.name = newName;
        systemGroup.description = newdescr;
        this.assert_SystemGroupInfo(systemGroup);
        systemGroup.name = oldName;
        this.exec_result = systemGroup.info();
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Could not find system group [ %s ] within organization [ %s ]", systemGroup.name, this.orgName));
    }

    @Test(description="Create system group, than copy it by specifying new name, description and max systems", groups={"cli-systemgroup"})
    public void test_copySystemGroup() {
        KatelloSystemGroup systemGroup = this.createSystemGroup();
        String sgroup_name2 = systemGroup.name + "copy";
        String newdescr = "new description";
        this.exec_result = systemGroup.copy(sgroup_name2, newdescr, 1);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Successfully copied system group [ %s ] to [ %s ]", systemGroup.name, sgroup_name2));
        KatelloSystemGroup systemGroup2 = new KatelloSystemGroup(sgroup_name2, this.orgName, newdescr, 1);
        this.assert_SystemGroupInfo(systemGroup2);
        this.assert_systemGroupList(Arrays.asList(systemGroup, systemGroup2), new ArrayList<KatelloSystemGroup>());
    }

    @Test(description="Create system group, add system to it", groups={"cli-systemgroup"})
    public void test_addSystemToSystemGroup() {
        KatelloSystem sys = this.addSystemToSystemGroup();
        KatelloSystemGroup systemGroup = new KatelloSystemGroup(this.systemGroupName, this.orgName);
        systemGroup.totalSystems = 1;
        this.assert_SystemGroupInfo(systemGroup);
        this.assert_systemList(Arrays.asList(sys), new ArrayList<KatelloSystem>());
    }

    @Test(description="Remove system group", groups={"cli-systemgroup"})
    public void test_removeSystemFromSystemGroup() {
        KatelloSystem sys = this.addSystemToSystemGroup();
        KatelloSystemGroup systemGroup = new KatelloSystemGroup(this.systemGroupName, this.orgName);
        this.exec_result = systemGroup.remove_systems(this.system_uuid);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Successfully removed systems from system group [ %s ]", this.systemGroupName));
        systemGroup.totalSystems = 0;
        this.assert_SystemGroupInfo(systemGroup);
        this.assert_systemList(new ArrayList<KatelloSystem>(), Arrays.asList(sys));
    }

    @Test(description="Add 2 systems to system group which has max systems 1, verify the error", groups={"cli-systemgroup"})
    public void test_addSystemToLimitedSystemGroup() {
        this.systemGroupName = "system_group" + KatelloUtils.getUniqueID();
        KatelloSystemGroup systemGroup = new KatelloSystemGroup(this.systemGroupName, this.orgName, null, 1);
        this.exec_result = systemGroup.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloUtils.sshOnClient("subscription-manager clean");
        this.systemName = "localhost-" + KatelloUtils.getUniqueID();
        KatelloSystem sys = new KatelloSystem(this.systemName, this.orgName, null);
        this.exec_result = sys.rhsm_registerForce();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = sys.rhsm_identity();
        sys.uuid = this.system_uuid = KatelloCli.grepCLIOutput("Current identity is", this.exec_result.getStdout());
        this.exec_result = systemGroup.add_systems(this.system_uuid);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Successfully added systems to system group [ %s ]", this.systemGroupName));
        KatelloUtils.sshOnClient("subscription-manager clean");
        this.systemName = "localhost-" + KatelloUtils.getUniqueID();
        sys = new KatelloSystem(this.systemName, this.orgName, null);
        this.exec_result = sys.rhsm_registerForce();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = sys.rhsm_identity();
        sys.uuid = this.system_uuid = KatelloCli.grepCLIOutput("Current identity is", this.exec_result.getStdout());
        this.exec_result = systemGroup.add_systems(this.system_uuid);
        Assert.assertTrue((this.exec_result.getExitCode() == 144 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Validation failed: You cannot have more than %s system(s) associated with system group '%s'.", "1", this.systemGroupName));
    }

    @Test(description="Add 1 system to system group which has max systems 1, then remove it and add another one", groups={"cli-systemgroup"})
    public void test_addSystemToLimitedSystemGroupAfterRemoving() {
        this.systemGroupName = "system_group" + KatelloUtils.getUniqueID();
        KatelloSystemGroup systemGroup = new KatelloSystemGroup(this.systemGroupName, this.orgName, null, 1);
        this.exec_result = systemGroup.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloUtils.sshOnClient("subscription-manager clean");
        this.systemName = "localhost-" + KatelloUtils.getUniqueID();
        KatelloSystem sys = new KatelloSystem(this.systemName, this.orgName, null);
        this.exec_result = sys.rhsm_registerForce();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = sys.rhsm_identity();
        sys.uuid = this.system_uuid = KatelloCli.grepCLIOutput("Current identity is", this.exec_result.getStdout());
        this.exec_result = systemGroup.add_systems(this.system_uuid);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Successfully added systems to system group [ %s ]", this.systemGroupName));
        this.exec_result = systemGroup.remove_systems(this.system_uuid);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Successfully removed systems from system group [ %s ]", this.systemGroupName));
        KatelloUtils.sshOnClient("subscription-manager clean");
        this.systemName = "localhost-" + KatelloUtils.getUniqueID();
        sys = new KatelloSystem(this.systemName, this.orgName, null);
        this.exec_result = sys.rhsm_registerForce();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = sys.rhsm_identity();
        sys.uuid = this.system_uuid = KatelloCli.grepCLIOutput("Current identity is", this.exec_result.getStdout());
        this.exec_result = systemGroup.add_systems(this.system_uuid);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Successfully added systems to system group [ %s ]", this.systemGroupName));
    }

    @Test(description="Copy system group with system", groups={"cli-systemgroup"})
    public void test_copySystemGroupWithSystem() {
        KatelloSystem sys = this.addSystemToSystemGroup();
        KatelloSystemGroup systemGroup = new KatelloSystemGroup(this.systemGroupName, this.orgName);
        this.systemGroupName = systemGroup.name + "copy";
        String newdescr = "new description";
        this.exec_result = systemGroup.copy(this.systemGroupName, newdescr, 1);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloSystemGroup systemGroup2 = new KatelloSystemGroup(this.systemGroupName, this.orgName, newdescr, 1);
        systemGroup2.totalSystems = 1;
        this.assert_SystemGroupInfo(systemGroup2);
        this.assert_systemList(Arrays.asList(sys), new ArrayList<KatelloSystem>());
    }

    @Test(description="List system groups", groups={"cli-systemgroup"})
    public void test_listSystemGroup() {
        KatelloSystemGroup systemGroup = this.createSystemGroup();
        String sgroup_name2 = "system_group" + KatelloUtils.getUniqueID();
        KatelloSystemGroup systemGroup2 = new KatelloSystemGroup(sgroup_name2, this.orgName);
        this.exec_result = systemGroup2.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.assert_systemGroupList(Arrays.asList(systemGroup, systemGroup2), new ArrayList<KatelloSystemGroup>());
    }

    @Test(description="Delete created system group and verify that it is not shown in list", groups={"cli-systemgroup"})
    public void test_deleteSystemGroup() {
        KatelloSystemGroup systemGroup = this.createSystemGroup();
        String sgroup_name2 = "system_group" + KatelloUtils.getUniqueID();
        KatelloSystemGroup systemGroup2 = new KatelloSystemGroup(sgroup_name2, this.orgName);
        this.exec_result = systemGroup2.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String sgroupID2 = this.assert_SystemGroupInfo(systemGroup2);
        this.exec_result = systemGroup2.delete();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)("Deleted system group '" + sgroupID2 + "'"));
        this.exec_result = systemGroup2.info();
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Could not find system group [ %s ] within organization [ %s ]", sgroup_name2, this.orgName));
        this.assert_systemGroupList(Arrays.asList(systemGroup), Arrays.asList(systemGroup2));
    }

    private KatelloSystemGroup createSystemGroup() {
        this.systemGroupName = "system_group" + KatelloUtils.getUniqueID();
        KatelloSystemGroup systemGroup = new KatelloSystemGroup(this.systemGroupName, this.orgName);
        this.exec_result = systemGroup.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).equals(String.format("Successfully created system group [ %s ]", this.systemGroupName)), (String)"Check - output string (system_group create)");
        return systemGroup;
    }

    private KatelloSystem addSystemToSystemGroup() {
        KatelloSystemGroup systemGroup = this.createSystemGroup();
        KatelloUtils.sshOnClient("subscription-manager clean");
        this.systemName = "localhost-" + KatelloUtils.getUniqueID();
        KatelloSystem sys = new KatelloSystem(this.systemName, this.orgName, null);
        this.exec_result = sys.rhsm_registerForce();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.exec_result.getStdout().trim().contains("The system has been registered with id:"), (String)"Check - output (success)");
        this.exec_result = sys.rhsm_identity();
        sys.uuid = this.system_uuid = KatelloCli.grepCLIOutput("Current identity is", this.exec_result.getStdout());
        this.exec_result = systemGroup.add_systems(this.system_uuid);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Successfully added systems to system group [ %s ]", this.systemGroupName));
        return sys;
    }

    private void assert_systemGroupList(List<KatelloSystemGroup> systemGroups, List<KatelloSystemGroup> excludeSystemGroups) {
        String match_info;
        this.exec_result = new KatelloSystemGroup(null, this.orgName).list();
        for (KatelloSystemGroup sgroup : systemGroups) {
            if (sgroup.description == null) {
                sgroup.description = "None";
            }
            match_info = String.format(".*\\s+\\d+.*\\s+%s.*", sgroup.name).replaceAll("\"", "");
            Assert.assertTrue((boolean)this.getOutput(this.exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("System Group [%s] should be found in the result list", sgroup.name));
        }
        for (KatelloSystemGroup sgroup : excludeSystemGroups) {
            if (sgroup.description == null) {
                sgroup.description = "None";
            }
            match_info = String.format(".*\\s+\\d+.*\\s+%s.*", sgroup.name).replaceAll("\"", "");
            Assert.assertFalse((boolean)this.getOutput(this.exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("System Group [%s] should not be found in the result list", sgroup.name));
        }
    }

    private void assert_systemList(List<KatelloSystem> systems, List<KatelloSystem> excludeSystems) {
        String match_info;
        this.exec_result = new KatelloSystemGroup(this.systemGroupName, this.orgName).list_systems();
        for (KatelloSystem system : systems) {
            match_info = String.format(".*\\s+%s.*\\s+%s.*", system.uuid, system.name).replaceAll("\"", "");
            Assert.assertTrue((boolean)this.getOutput(this.exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("System [%s] should be found in the system group [%s] list", system.name, this.systemGroupName));
        }
        for (KatelloSystem system : excludeSystems) {
            match_info = String.format(".*\\s+%s.*\\s+%s.*", system.uuid, system.name).replaceAll("\"", "");
            Assert.assertFalse((boolean)this.getOutput(this.exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("System [%s] should not be found in the system group [%s] list", system.name, this.systemGroupName));
        }
    }

    private String assert_SystemGroupInfo(KatelloSystemGroup systemGroup) {
        if (systemGroup.description == null) {
            systemGroup.description = "None";
        }
        this.exec_result = systemGroup.info();
        String match_info = String.format(".*Id:\\s+\\d+.*Name:\\s+%s.*Description:\\s+%s.*Total Systems:\\s+%s.*", systemGroup.name, systemGroup.description, systemGroup.totalSystems).replaceAll("\"", "");
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        log.finest(String.format("System Group (info) match regex: [%s]", match_info));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("System Group [%s] should be found in the result info", systemGroup.name));
        String id = KatelloCli.grepCLIOutput("Id", this.exec_result.getStdout());
        return id;
    }
}

