/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.e2e;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloChangeset;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloPackage;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.base.obj.KatelloSystem;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ProductsSameName
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(ProductsSameName.class.getName());
    private SSHCommandResult exec_result;
    private String org_name;
    private String repo_name;
    private String repo_name2;
    private String env_name;
    private String provider_name;
    private String product_name;
    private String product_name2;
    private String changeset_name;
    private String system_name;

    @BeforeClass(description="Generate unique objects")
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.org_name = "org" + uid;
        this.provider_name = "provider" + uid;
        this.product_name2 = this.product_name = "product" + uid;
        this.repo_name = "repo1" + uid;
        this.repo_name2 = "repo2" + uid;
        this.env_name = "env" + uid;
        this.changeset_name = "changeset" + uid;
        this.system_name = "system" + uid;
        KatelloOrg org = new KatelloOrg(this.org_name, "Package tests");
        this.exec_result = org.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProvider prov = new KatelloProvider(this.provider_name, this.org_name, "Package provider", null);
        this.exec_result = prov.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod = new KatelloProduct(this.product_name, this.org_name, this.provider_name, null, null, null, null, null);
        this.exec_result = prod.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod2 = new KatelloProduct(this.product_name2, this.org_name, this.provider_name, null, null, null, null, null);
        this.exec_result = prod2.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloRepo repo = new KatelloRepo(this.repo_name, this.org_name, this.product_name, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/6Server/x86_64/", null, null);
        this.exec_result = repo.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloRepo repo2 = new KatelloRepo(this.repo_name2, this.org_name, this.product_name, "http://inecas.fedorapeople.org/fakerepos/zoo3/", null, null);
        this.exec_result = repo2.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloEnvironment env = new KatelloEnvironment(this.env_name, null, this.org_name, "Library");
        this.exec_result = env.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloChangeset cs = new KatelloChangeset(this.changeset_name, this.org_name, this.env_name);
        this.exec_result = cs.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        repo.synchronize();
        repo2.synchronize();
        cs.update_addProduct(this.product_name);
        cs.update_addProduct(this.product_name2);
        cs.update_fromProduct_addRepo(this.product_name, this.repo_name);
        cs.update_fromProduct_addRepo(this.product_name2, this.repo_name2);
        cs.promote();
    }

    @Test(description="package list of two repos")
    public void test_packageList() {
        KatelloPackage pack = new KatelloPackage(null, null, this.org_name, this.product_name, this.repo_name, null);
        this.exec_result = pack.cli_list();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("pulp-admin"));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("pulp"));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("python-gofer"));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("python-qpid"));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("pulp-common"));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("pulp-consumer"));
        KatelloPackage pack2 = new KatelloPackage(null, null, this.org_name, this.product_name2, this.repo_name2, null);
        this.exec_result = pack2.cli_list();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("lion"));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("wolf"));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("zebra"));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("stork"));
    }

    @Test(description="install packages of two repos")
    public void testInstallPackage() {
        this.rhsm_clean();
        KatelloSystem sys = new KatelloSystem(this.system_name, this.org_name, this.env_name);
        this.exec_result = sys.rhsm_registerForce();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = sys.subscriptions_available();
        String poolId1 = KatelloCli.grepCLIOutput("Id", this.getOutput(this.exec_result).trim(), 1);
        this.exec_result = sys.rhsm_subscribe(poolId1);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = sys.subscriptions_available();
        String poolId2 = KatelloCli.grepCLIOutput("Id", this.getOutput(this.exec_result).trim(), 1);
        this.exec_result = sys.rhsm_subscribe(poolId2);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = KatelloUtils.sshOnClient("yum -y install lion");
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (install lion)");
        this.exec_result = KatelloUtils.sshOnClient("yum -y install pulp-consumer");
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (install lion)");
    }
}

