/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.common.KatelloConstants;
import com.redhat.qe.tools.SSHCommandResult;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CliSyncRepo
implements KatelloConstants {
    String orgname;
    String providername;
    String productname;
    String reponame;

    @BeforeClass(description="prepare an org to work with")
    public void setup() {
        this.orgname = "CFSE QE Org";
        this.providername = "provider Zoo";
        this.productname = "Zoo Corp";
        this.reponame = "zoo3";
        KatelloOrg org = new KatelloOrg(this.orgname, "Demo org");
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (org create)");
        KatelloEnvironment env = new KatelloEnvironment("Development", null, this.orgname, "Library");
        env.cli_create();
        env = new KatelloEnvironment("Testing", null, this.orgname, "Development");
        env.cli_create();
        env = new KatelloEnvironment("Production", null, this.orgname, "Testing");
        env.cli_create();
    }

    @Test
    public void test_generate_provProdRepoAndSync() {
        KatelloProvider prov = new KatelloProvider(this.providername, this.orgname, null, null);
        KatelloProduct prod = new KatelloProduct(this.productname, this.orgname, this.providername, null, null, null, null, null);
        KatelloRepo repo = new KatelloRepo(this.reponame, this.orgname, this.productname, "http://inecas.fedorapeople.org/fakerepos/zoo3/", null, null);
        prov.create();
        prod.create();
        repo.create();
        SSHCommandResult res = repo.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (repo sync)");
    }

    @AfterClass(description="destroy the org - make scenario reusable", alwaysRun=true)
    public void cleanup() {
        KatelloOrg org = new KatelloOrg(this.orgname, null);
        SSHCommandResult res = org.delete();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (org delete)");
    }
}

