/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import javax.management.Attribute;

public class KatelloChangeset {
    public static final String CMD_CREATE = "changeset create";
    public static final String CMD_APPLY = "changeset apply";
    public static final String CMD_PROMOTE = "changeset promote";
    public static final String CMD_UPDATE = "changeset update";
    public static final String CMD_DELETE = "changeset delete";
    public static final String CMD_INFO = "changeset info";
    public static final String CMD_LIST = "changeset list";
    public static final String OUT_CREATE = "Successfully created changeset [ %s ] for environment [ %s ]";
    public static final String OUT_DELETE = "Deleted changeset '%s'";
    public static final String ERR_NOT_FOUND = "Could not find changeset [ %s ] within environment [ %s ]";
    public static final String OUT_UPDATE = "Successfully updated changeset [ %s ]";
    public static final String OUT_APPLIED = "Changeset [ %s ] applied";
    public static final String REG_CHST_INFO = ".*Id:\\s+\\d+.*Name:\\s+%s.*Description:\\s+%s.*State:\\s+%s.*Environment Name:\\s+%s.*";
    public static final String REG_CHST_ID = "Id:\\s+\\d+\\s+Name:";
    public static final String REG_CHST_LIST = ".*\\s+\\d+.*\\s+%s.*\\s+%s.*";
    public static final String REG_CHST_PACKAGES = ".*Packages:\\s+.*%s.*";
    public static final String REG_CHST_PRODUCTS = ".*Products:\\s+.*%s.*";
    public static final String REG_CHST_REPOS = ".*Repositories:\\s+.*%s.*";
    public static final String REG_CHST_TEMPLS = ".*System Templates:\\s+.*%s.*";
    public static final String REG_CHST_ERRATA = ".*Errata:\\s+.*%s.*";
    public String name;
    public String org;
    public String description;
    public String environment;
    public String state;
    private boolean isDeletion;
    private KatelloCli cli;
    private ArrayList<Attribute> opts;

    public KatelloChangeset(String pName, String pOrg, String pEnv) {
        this(pName, pOrg, pEnv, false);
    }

    public KatelloChangeset(String pName, String pOrg, String pEnv, boolean pisDeletion) {
        this.name = pName;
        this.org = pOrg;
        this.environment = pEnv;
        this.isDeletion = pisDeletion;
        this.opts = new ArrayList();
    }

    public SSHCommandResult create() {
        return this.create(null);
    }

    public SSHCommandResult create(KatelloUser user) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", this.environment));
        if (this.isDeletion) {
            this.opts.add(new Attribute("deletion", "true"));
        }
        this.cli = user == null ? new KatelloCli(CMD_CREATE, this.opts) : new KatelloCli(CMD_CREATE, this.opts, user);
        return this.cli.run();
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", this.environment));
        this.cli = new KatelloCli(CMD_DELETE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult list() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("environment", this.environment));
        this.cli = new KatelloCli(CMD_LIST, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult promote() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", this.environment));
        this.cli = new KatelloCli(CMD_PROMOTE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult apply() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", this.environment));
        this.cli = new KatelloCli(CMD_APPLY, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult info() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", this.environment));
        this.cli = new KatelloCli(CMD_INFO, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_name(String newname) {
        this.opts.clear();
        this.opts.add(new Attribute("new_name", newname));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", this.environment));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_addProduct(String productName) {
        this.opts.clear();
        this.opts.add(new Attribute("add_product", productName));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", this.environment));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_removeProduct(String productName) {
        this.opts.clear();
        this.opts.add(new Attribute("remove_product", productName));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", this.environment));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_add_package(String productName, String pkg) {
        this.opts.clear();
        this.opts.add(new Attribute("from_product", productName));
        this.opts.add(new Attribute("add_package", pkg));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("environment", this.environment));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_fromProduct_addRepo(String productName, String repoName) {
        this.opts.clear();
        this.opts.add(new Attribute("from_product", productName));
        this.opts.add(new Attribute("add_repo", repoName));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", this.environment));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_fromProduct_removeRepo(String productName, String repoName) {
        this.opts.clear();
        this.opts.add(new Attribute("from_product", productName));
        this.opts.add(new Attribute("remove_repo", repoName));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", this.environment));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_fromProduct_addErrata(String productName, String errataName) {
        this.opts.clear();
        this.opts.add(new Attribute("from_product", productName));
        this.opts.add(new Attribute("add_erratum", errataName));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", this.environment));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_fromProduct_removeErrata(String productName, String errataName) {
        this.opts.clear();
        this.opts.add(new Attribute("from_product", productName));
        this.opts.add(new Attribute("remove_erratum", errataName));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", this.environment));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_addTemplate(String templateName) {
        this.opts.clear();
        this.opts.add(new Attribute("add_template", templateName));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", this.environment));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_removeTemplate(String templateName) {
        this.opts.clear();
        this.opts.add(new Attribute("remove_template", templateName));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", this.environment));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }
}

