/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import javax.management.Attribute;

public class KatelloFilter {
    public static final String CMD_CREATE = "filter create";
    public static final String CLI_CMD_INFO = "filter info";
    public static final String CLI_CMD_LIST = "filter list";
    public static final String CMD_DELETE = "filter delete";
    public static final String CLI_CMD_ADD_PACKAGE = "filter add_package";
    public static final String CLI_CMD_REMOVE_PACKAGE = "filter remove_package";
    public static final String OUT_CREATE = "Successfully created filter [ %s ]";
    public static final String ERR_FILTER_NOTFOUND = "Couldn't find filter '%s'";
    public static final String OUT_PACKAGE_ADD = "Successfully added package [ %s ] to filter [ %s ]";
    public static final String OUT_PACKAGE_REMOVE = "Successfully removed package [ %s ] from filter [ %s ]";
    public static final String REG_FILTER_INFO = ".*Name:\\s+%s.*Description:\\s+%s.*Package List:\\s+%s.*";
    public static final String REG_FILTER_LIST = ".*%s\\s+%s.*";
    public String name;
    public String org;
    public String packages;
    public String description;
    private KatelloCli cli;
    private ArrayList<Attribute> opts;

    public KatelloFilter(String pName, String pOrg, String pEnv, String pPackages) {
        this.name = pName;
        this.org = pOrg;
        this.packages = pPackages;
        this.opts = new ArrayList();
    }

    public SSHCommandResult create() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("packages", this.packages));
        this.cli = new KatelloCli(CMD_CREATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_info() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CLI_CMD_INFO, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_list() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.cli = new KatelloCli(CLI_CMD_LIST, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("org", this.org));
        this.cli = new KatelloCli(CMD_DELETE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_addPackage(String packageName) {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("package", packageName));
        this.cli = new KatelloCli(CLI_CMD_ADD_PACKAGE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_removePackage(String packageName) {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("package", packageName));
        this.cli = new KatelloCli(CLI_CMD_REMOVE_PACKAGE, this.opts);
        return this.cli.run();
    }
}

