/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliDataProvider;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloActivationKey;
import com.redhat.qe.katello.base.obj.KatelloChangeset;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloSystem;
import com.redhat.qe.katello.base.obj.KatelloSystemGroup;
import com.redhat.qe.katello.base.obj.KatelloTemplate;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ActivationKeyTests
extends KatelloCliTestScript {
    private String organization;
    private String env;
    private String systemgroup;

    @BeforeClass(description="init: create org stuff", groups={"cli-activationkey", "headpin-cli"})
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.organization = "ak-" + uid;
        this.env = "ak-" + uid;
        KatelloOrg org = new KatelloOrg(this.organization, null);
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloEnvironment env = new KatelloEnvironment(this.env, null, this.organization, "Library");
        res = env.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
    }

    @Test(description="create AK", groups={"cli-activationkey", "headpin-cli"}, dataProvider="activationkey_create", dataProviderClass=KatelloCliDataProvider.class, enabled=true)
    public void test_create(String name, String descr, Integer exitCode, String output) {
        KatelloActivationKey ak = new KatelloActivationKey(this.organization, this.env, name, descr, null);
        SSHCommandResult res = ak.create();
        Assert.assertTrue((res.getExitCode().intValue() == exitCode.intValue() ? 1 : 0) != 0, (String)"Check - return code");
        if (exitCode == 0) {
            Assert.assertTrue((boolean)this.getOutput(res).contains(output), (String)"Check - returned output string");
        } else {
            Assert.assertTrue((boolean)this.getOutput(res).contains(output), (String)"Check - returned error string");
        }
    }

    @Test(description="create AK - template does not exist", groups={"cli-activationkey"}, enabled=true)
    public void test_create_noTemplate() {
        String template_name;
        String uid = KatelloUtils.getUniqueID();
        String ak_name = "ne-" + uid;
        KatelloActivationKey ak = new KatelloActivationKey(this.organization, this.env, ak_name, null, template_name = "neTemplate-" + uid);
        SSHCommandResult res = ak.create();
        Assert.assertTrue((res.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code (activation_key create --template)");
        Assert.assertTrue((boolean)this.getOutput(res).trim().contains(String.format("Could not find template [ %s ]", template_name)), (String)"Check - returned error string (activation_key create --template)");
    }

    @Test(description="create AK - template not exported to the env.", groups={"cli-activationkey"}, enabled=true)
    public void test_create_TemplateNotForEnv() {
        String uid = KatelloUtils.getUniqueID();
        String template = "template-" + uid;
        String ak_name = "nfe-" + uid;
        KatelloTemplate tmpl = new KatelloTemplate(template, null, this.organization, null);
        SSHCommandResult res = tmpl.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (template create)");
        KatelloActivationKey ak = new KatelloActivationKey(this.organization, this.env, ak_name, null, template);
        res = ak.create();
        Assert.assertTrue((res.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code (activation_key create --template)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Could not find template [ %s ]", template)), (String)"Check - returned error string (activation_key create --template)");
    }

    @Test(description="create AK - same name, diff. orgs", groups={"cli-activationkey", "headpin-cli"}, enabled=true)
    public void test_create_diffOrgsSameName() {
        String uid = KatelloUtils.getUniqueID();
        String ak_name = "ak-" + uid;
        String org2 = "org2-" + uid;
        KatelloOrg org = new KatelloOrg(org2, null);
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloEnvironment env = new KatelloEnvironment(this.env, null, org2, "Library");
        res = env.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloActivationKey ak = new KatelloActivationKey(org2, this.env, ak_name, null, null);
        res = ak.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key create)");
        ak = new KatelloActivationKey(this.organization, this.env, ak_name, null, null);
        res = ak.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created activation key [ %s ]", ak_name)), (String)"Check - returned output string (activation_key create)");
        ak.asserts_create();
    }

    @Test(description="create AK - with template", groups={"cli-activationkey"}, enabled=true)
    public void test_create_withTemplate() {
        String uid = KatelloUtils.getUniqueID();
        String template = "templateForEnv-" + uid;
        String changeset = "csForEnv-" + uid;
        String ak_name = "akTemplate-" + uid;
        KatelloTemplate tmpl = new KatelloTemplate(template, null, this.organization, null);
        SSHCommandResult res = tmpl.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (template create)");
        KatelloChangeset cs = new KatelloChangeset(changeset, this.organization, this.env);
        res = cs.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset create)");
        res = cs.update_addTemplate(template);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset update --add_template)");
        res = cs.apply();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset promote)");
        KatelloActivationKey ak = new KatelloActivationKey(this.organization, this.env, ak_name, null, template);
        res = ak.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key create --template)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created activation key [ %s ]", ak_name)), (String)"Check - returned output string (activation_key create --template)");
        ak.asserts_create();
    }

    @Test(description="add subscription to ak", groups={"cli-activationkey"}, enabled=true)
    public void test_update_addSubscription1() {
        String uid = KatelloUtils.getUniqueID();
        String akName = "ak-subscription-zoo3-" + uid;
        String providerName = "Zoo3-" + uid;
        String productName = "Zoo3 " + uid;
        KatelloActivationKey ak = new KatelloActivationKey(this.organization, this.env, akName, "Activation key with Zoo3 subscription", null);
        SSHCommandResult res = ak.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key create)");
        KatelloProvider prov = new KatelloProvider(providerName, this.organization, null, null);
        prov.create();
        KatelloProduct prod = new KatelloProduct(productName, this.organization, providerName, null, null, null, null, null);
        res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product create)");
        KatelloOrg org = new KatelloOrg(this.organization, null);
        res = org.subscriptions();
    }

    @Test(description="delete a activationkey", groups={"headpin-cli"}, enabled=true)
    public void test_delete_activation_key() {
        String uid = KatelloUtils.getUniqueID();
        String akName = "ak-delete_act_key-" + uid;
        KatelloActivationKey ak = new KatelloActivationKey(this.organization, this.env, akName, "Activation key created to test deletion", null);
        SSHCommandResult res = ak.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created activation key [ %s ]", akName)), (String)"Check - returned output string (activation_key create)");
        res = ak.delete();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key delete)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully deleted activation key [ %s ]", akName)), (String)"Check - returned output string (activation_key delete)");
        res = ak.info();
        Assert.assertTrue((res.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code (activation_key delete)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Could not find activation key [ %s ]", akName)), (String)"Check - returned output string (activation_key info)");
        res = ak.list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key list)");
    }

    @Test(description="create activationkey with usage limit 1, register one system, and try to register second one, it will fail", groups={"headpin-cli"}, enabled=true)
    public void test_createWithLimit() {
        String uid = KatelloUtils.getUniqueID();
        String akName = "act_key-" + uid;
        KatelloActivationKey ak = new KatelloActivationKey(this.organization, this.env, akName, "Activation key created to ", null, "1");
        SSHCommandResult res = ak.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key create)");
        ak.asserts_create();
        KatelloUtils.sshOnClient("subscription-manager clean");
        String systemName = "localhost-" + KatelloUtils.getUniqueID();
        KatelloSystem sys = new KatelloSystem(systemName, this.organization, null);
        res = sys.rhsm_registerForce(akName);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloUtils.sshOnClient("subscription-manager clean");
        systemName = "localhost-" + KatelloUtils.getUniqueID();
        sys = new KatelloSystem(systemName, this.organization, null);
        res = sys.rhsm_registerForce(akName);
        Assert.assertTrue((res.getExitCode() == 255 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Usage limit (%s) exhausted for activation key '%s'", "1", akName)), (String)"Check - returned output string for registering by activation key");
    }

    @Test(description="create activationkey with usage limit 1, register one system, and try to register second one, it will fail, increase the limit, it will allow", groups={"headpin-cli"}, enabled=true)
    public void test_updateTheLimit() {
        String uid = KatelloUtils.getUniqueID();
        String akName = "act_key-" + uid;
        KatelloActivationKey ak = new KatelloActivationKey(this.organization, this.env, akName, "Activation key created to ", null, "1");
        SSHCommandResult res = ak.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key create)");
        ak.asserts_create();
        KatelloUtils.sshOnClient("subscription-manager clean");
        String systemName = "localhost-" + KatelloUtils.getUniqueID();
        KatelloSystem sys = new KatelloSystem(systemName, this.organization, null);
        res = sys.rhsm_registerForce(akName);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloUtils.sshOnClient("subscription-manager clean");
        systemName = "localhost-" + KatelloUtils.getUniqueID();
        sys = new KatelloSystem(systemName, this.organization, null);
        res = sys.rhsm_registerForce(akName);
        Assert.assertTrue((res.getExitCode() == 255 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Usage limit (%s) exhausted for activation key '%s'", "1", akName)), (String)"Check - returned output string for registering by activation key");
        ak.extend_limit("2");
        res = sys.rhsm_registerForce(akName);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
    }

    @Test(description="add system group to activationkey", groups={"cli-activationkey"}, enabled=true)
    public void test_addSystemGroup() {
        String uid = KatelloUtils.getUniqueID();
        this.systemgroup = "systemgroup" + uid;
        String akName = "ak-subscription-zoo3-" + uid;
        KatelloActivationKey ak = new KatelloActivationKey(this.organization, this.env, akName, "Activation key to add system group", null);
        SSHCommandResult res = ak.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key create)");
        KatelloSystemGroup systemGroup = new KatelloSystemGroup(this.systemgroup, this.organization);
        res = systemGroup.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        res = ak.add_system_group(this.systemgroup);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key add_system_group)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully added system group to activation key [ %s ]", akName)), (String)"Check - returned output string (activation_key add_system_group)");
    }

    @Test(description="remove system group from activationkey", groups={"cli-activationkey"}, enabled=true)
    public void test_removeSystemGroup() {
        String uid = KatelloUtils.getUniqueID();
        this.systemgroup = "systemgroup" + uid;
        String akName = "ak-subscription-zoo3-" + uid;
        KatelloActivationKey ak = new KatelloActivationKey(this.organization, this.env, akName, "Activation key to add and remove system group", null);
        SSHCommandResult res = ak.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key create)");
        KatelloSystemGroup systemGroup = new KatelloSystemGroup(this.systemgroup, this.organization);
        res = systemGroup.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        res = ak.add_system_group(this.systemgroup);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key add_system_group)");
        res = ak.remove_system_group(this.systemgroup);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key remove_system_group)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully removed system group from activation key [ %s ]", akName)), (String)"Check - returned output string (activation_key remove_system_group)");
    }
}

