/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.e2e;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloChangeset;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.base.obj.KatelloSystem;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-e2e"})
public class ChangesetMultyRepoDelete
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(ChangesetMultyRepoDelete.class.getName());
    private String org_name;
    private String env_name;
    private String system_name;
    private String provider_name;
    private String product_name;
    private String repo_name;
    private String provider_name2;
    private String product_name2;
    private String repo_name2;
    private String chst_name;
    private String delchst_name;
    SSHCommandResult exec_result;

    @BeforeClass(description="init: create all stuff")
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.org_name = "org" + uid;
        KatelloOrg org = new KatelloOrg(this.org_name, "Package tests");
        this.exec_result = org.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
    }

    @Test(description="Create changeset of deletion type, then add already rpomoted two repos to changeset and promote them, verify that repos does not exist in environment anymore")
    public void test_deletionChangesetRemoveTwoRepos() {
        this.setupRepos();
        KatelloRepo repo = new KatelloRepo(null, this.org_name, null, null, null, null);
        this.exec_result = repo.list(this.env_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(this.repo_name));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(this.repo_name2));
        KatelloChangeset chst = new KatelloChangeset(this.delchst_name, this.org_name, this.env_name, true);
        this.exec_result = chst.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset create)");
        this.exec_result = chst.update_fromProduct_addRepo(this.product_name, this.repo_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset update)");
        this.exec_result = chst.update_fromProduct_addRepo(this.product_name2, this.repo_name2);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset update)");
        this.exec_result = chst.apply();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset apply)");
        this.exec_result = repo.list(this.env_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertFalse((boolean)this.getOutput(this.exec_result).contains(this.repo_name));
        Assert.assertFalse((boolean)this.getOutput(this.exec_result).contains(this.repo_name2));
        this.yum_clean();
        this.exec_result = KatelloUtils.sshOnClient("yum -y install lion");
        Assert.assertFalse((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (install lion)");
        this.exec_result = KatelloUtils.sshOnClient("yum -y install pulp*");
        Assert.assertFalse((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (install pulp*)");
    }

    private void setupRepos() {
        String uid = KatelloUtils.getUniqueID();
        String uid2 = KatelloUtils.getUniqueID();
        this.env_name = "env" + uid;
        this.provider_name = "provider" + uid;
        this.product_name = "product" + uid;
        this.repo_name = "repo" + uid;
        this.provider_name2 = "provider" + uid2;
        this.product_name2 = "product" + uid2;
        this.repo_name2 = "repo" + uid2;
        this.chst_name = "changeset" + uid;
        this.delchst_name = "deletion_chst" + uid;
        this.system_name = "system" + uid;
        KatelloProvider prov = new KatelloProvider(this.provider_name, this.org_name, "Package provider", null);
        this.exec_result = prov.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod = new KatelloProduct(this.product_name, this.org_name, this.provider_name, null, null, null, null, null);
        this.exec_result = prod.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloRepo repo = new KatelloRepo(this.repo_name, this.org_name, this.product_name, "http://inecas.fedorapeople.org/fakerepos/zoo3/", null, null);
        this.exec_result = repo.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProvider prov2 = new KatelloProvider(this.provider_name2, this.org_name, "Package provider", null);
        this.exec_result = prov2.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod2 = new KatelloProduct(this.product_name2, this.org_name, this.provider_name2, null, null, null, null, null);
        this.exec_result = prod2.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloRepo repo2 = new KatelloRepo(this.repo_name2, this.org_name, this.product_name2, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/6Server/x86_64/", null, null);
        this.exec_result = repo2.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloEnvironment env = new KatelloEnvironment(this.env_name, null, this.org_name, "Library");
        this.exec_result = env.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (env create)");
        this.exec_result = prod.promote(this.env_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product promote)");
        this.exec_result = repo.synchronize();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = prod2.promote(this.env_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (product promote)");
        this.exec_result = repo2.synchronize();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloChangeset cs = new KatelloChangeset(this.chst_name, this.org_name, this.env_name);
        this.exec_result = cs.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset create)");
        this.exec_result = cs.update_fromProduct_addRepo(this.product_name, this.repo_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset update)");
        this.exec_result = cs.update_fromProduct_addRepo(this.product_name2, this.repo_name2);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset update)");
        this.exec_result = cs.apply();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset apply)");
        this.rhsm_clean();
        KatelloSystem sys = new KatelloSystem(this.system_name, this.org_name, this.env_name);
        this.exec_result = sys.rhsm_registerForce();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = sys.subscriptions_available();
        String poolId1 = KatelloCli.grepCLIOutput("Id", this.getOutput(this.exec_result).trim(), 1);
        this.exec_result = sys.rhsm_subscribe(poolId1);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = sys.subscriptions_available();
        String poolId2 = KatelloCli.grepCLIOutput("Id", this.getOutput(this.exec_result).trim(), 1);
        this.exec_result = sys.rhsm_subscribe(poolId2);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.yum_clean();
    }
}

