/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.upgrade.v1;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.obj.KatelloChangeset;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.katello.common.KatelloConstants;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import org.testng.annotations.Test;

public class PrepopulatedSystemUpgradePath
implements KatelloConstants {
    protected static Logger log = Logger.getLogger(PrepopulatedSystemUpgradePath.class.getName());
    String _uid = KatelloUtils.getUniqueID();
    String[] _orgs = new String[]{"Tokyo_" + this._uid, "SaoPaulo_" + this._uid, "Paris_" + this._uid, "Dakar_" + this._uid};
    String[][] _envs = new String[][]{{"Dev", "QA", "Release"}, {"Desenvolvimento", "ControleQualidade", "Final"}, {"Dev1", "QA1", "Release1"}, {"Dev", "QA", "GA"}};

    @Test(description="create organizations", groups={"pre-upgrade"})
    public void create_orgs() {
        log.info("initialize organizations ...");
        for (String org : this._orgs) {
            KatelloOrg tmpOrg = new KatelloOrg(org, null);
            SSHCommandResult res = tmpOrg.cli_create();
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - exit code (org create)");
        }
    }

    @Test(description="create environments for each org", dependsOnMethods={"create_orgs"}, groups={"pre-upgrade"})
    public void create_envs() {
        log.info("initialize environments ...");
        String prior = "Library";
        for (int i = 0; i < this._orgs.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                KatelloEnvironment tmpEnv = new KatelloEnvironment(this._envs[i][j], null, this._orgs[i], prior);
                SSHCommandResult res = tmpEnv.cli_create();
                Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - exit code (environment create)");
                if (i == 2) {
                    tmpEnv = new KatelloEnvironment(this._envs[i][j].replace('1', '2'), null, this._orgs[i], prior.replace('1', '2'));
                    res = tmpEnv.cli_create();
                    Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - exit code (environment create)");
                }
                prior = this._envs[i][j];
            }
            prior = "Library";
        }
    }

    @Test(description="create users", dependsOnMethods={"create_orgs"}, groups={"pre-upgrade"})
    public void create_users() {
        log.info("initialize users ...");
        KatelloUser user = new KatelloUser("Akihito" + this._uid, "Akihito@localhost", "redhat", false);
        SSHCommandResult res = user.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - exit code (user create)");
        user = new KatelloUser("Dilma_Rousseff" + this._uid, "Dilma_Rousseff@localhost", "redhat", false);
        res = user.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - exit code (user create)");
        user = new KatelloUser("Ollanta_Humala" + this._uid, "Ollanta_Humala@localhost", "redhat", false);
        res = user.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - exit code (user create)");
    }

    @Test(description="create custom repositories", dependsOnMethods={"create_envs"}, groups={"pre-upgrade"})
    public void create_repos() {
        String[] repo_links = new String[]{"http://download.lab.bos.redhat.com/released/RHEL-6-JBEAP-6/6.0.0/Server/x86_64/", "http://inecas.fedorapeople.org/fakerepos/zoo3/", "http://download.lab.bos.redhat.com/released/RHEL-6-RHN-Tools/5.4.1/AS/x86_64/tree/RHNTools/"};
        for (int i = 0; i < this._orgs.length - 1; ++i) {
            KatelloProvider prov = new KatelloProvider("Provider " + this._uid, this._orgs[i], null, null);
            KatelloProduct prod = new KatelloProduct("Product " + this._uid, this._orgs[i], prov.name, null, null, null, null, null);
            SSHCommandResult res = prov.create();
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - exit code (provider create)");
            res = prod.create();
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - exit code (product create)");
            KatelloRepo repo = new KatelloRepo("Repo " + this._uid, this._orgs[i], "Product " + this._uid, repo_links[i], null, null);
            res = repo.create();
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - exit code (repo create)");
            res = repo.synchronize();
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - exit code (repo synchronize)");
            this.pushRepoFullCycle(this._orgs[i], this._envs[i], "Repo " + this._uid, repo_links[i]);
            if (i != 2) continue;
            String[] org2Envs2 = new String[]{"", "", ""};
            for (int k = 0; k < 3; ++k) {
                org2Envs2[k] = this._envs[i][k].replace('1', '2');
            }
            this.pushRepoFullCycle(this._orgs[i], org2Envs2, "Repo " + this._uid, repo_links[i]);
        }
    }

    private void pushRepoFullCycle(String org, String[] envs, String reponame, String url) {
        log.info("promote repo to all environments for the org: [" + org + "]");
        for (int i = 0; i < envs.length; ++i) {
            KatelloChangeset cs = new KatelloChangeset("cs_" + envs[i], org, envs[i]);
            SSHCommandResult res = cs.create();
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - exit code (changeset create)");
            cs.update_addProduct("Product " + this._uid);
            res = cs.apply();
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - exit code (changeset apply)");
        }
    }
}

