/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloGpgKey;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-cli"})
public class GpgKeyTests
extends KatelloCliTestScript {
    private String rand;
    private String org;
    private String gpg;
    private String filename;

    @BeforeClass(description="init: create org, prepare gpg file on disk")
    public void setUp() {
        this.rand = KatelloUtils.getUniqueID();
        this.org = "gpg-" + this.rand;
        this.filename = "/tmp/RPM-GPG-KEY-dummy-packages-generator";
        this.gpg = "gpgkey-" + this.rand;
        KatelloOrg org = new KatelloOrg(this.org, "Org for GPG cli tests");
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (org create)");
        String cmd = "rm -f " + this.filename + "; " + "curl -sk " + "http://inecas.fedorapeople.org/fakerepos/zoo/RPM-GPG-KEY-dummy-packages-generator" + " -o " + this.filename;
        res = KatelloUtils.sshOnClient(cmd);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (get gpg file)");
    }

    @Test(description="simply create a gpg key: nothing yet")
    public void create_noProdnoRepo() {
        KatelloGpgKey gpg = new KatelloGpgKey(this.gpg, this.org, this.filename);
        SSHCommandResult res = gpg.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (gpg_key create)");
        Assert.assertTrue((boolean)this.getOutput(res).trim().equals(String.format("Successfully created GPG key [ %s ]", this.gpg)), (String)"Check - stdout (gpg_key create)");
    }

    @Test(description="info on gpg key - nothing yet", dependsOnMethods={"create_noProdnoRepo"})
    public void info_noProdnoRepo() {
        KatelloGpgKey gpg = new KatelloGpgKey(this.gpg, this.org, null);
        SSHCommandResult res = gpg.cli_info();
        String prods = KatelloCli.grepCLIOutput("Products", this.getOutput(res));
        String repos = KatelloCli.grepCLIOutput("Repositories", this.getOutput(res));
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (gpg_key info)");
        Assert.assertTrue((boolean)prods.equals("[  ]"), (String)"Check - product list is empty");
        Assert.assertTrue((boolean)repos.equals("[  ]"), (String)"Check - repositories list is empty");
    }

    @Test(description="list gpg keys", dependsOnMethods={"create_noProdnoRepo"})
    public void list() {
        SSHCommandResult res = new KatelloGpgKey(this.gpg, this.org, null).cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (gpg_key list)");
        String REGEXP_GPG = ".*Name:\\s+" + this.gpg + ".*";
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_GPG), (String)"Check - gpg key should be listed");
    }

    @Test(description="list gpg keys", dependsOnMethods={"create_noProdnoRepo", "info_noProdnoRepo", "list"})
    public void delete() {
        KatelloGpgKey gpg = new KatelloGpgKey(this.gpg, this.org, null);
        SSHCommandResult res = gpg.cli_delete();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (gpg_key delete)");
        String REGEXP_GPG = ".*Name:\\s+" + this.gpg + ".*";
        Assert.assertFalse((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_GPG), (String)"Check - gpg key should not be listed");
        res = gpg.cli_info();
        Assert.assertTrue((res.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code (gpg_key info)");
        Assert.assertTrue((boolean)this.getOutput(res).equals(String.format("Could not find GPG key [ %s ]", this.gpg)), (String)"Check - gpg info error string");
    }
}

