/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloFilter;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-cli"})
public class FilterTests
extends KatelloCliTestScript {
    String org;
    String environment;

    @BeforeClass(description="init: create org stuff", groups={"cli-filter"})
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.org = "filter-" + uid;
        this.environment = "Dev-" + uid;
        KatelloOrg org = new KatelloOrg(this.org, null);
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (org create)");
        KatelloEnvironment env = new KatelloEnvironment(this.environment, null, this.org, "Library");
        res = env.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (env create)");
    }

    @Test(description="Create filter: no packages", groups={"cli-filter"})
    public void test_createWithoutPackages() {
        String filterName = "filter" + KatelloUtils.getUniqueID();
        KatelloFilter filter = new KatelloFilter(filterName, this.org, null, null);
        SSHCommandResult res = filter.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (filter create)");
        Assert.assertTrue((boolean)this.getOutput(res).equals(String.format("Successfully created filter [ %s ]", filterName)), (String)"Check - output string (filter create)");
    }

    @Test(description="Create filter: with packages", groups={"cli-filter"})
    public void test_createWithPackages() {
        String filterName = "filter" + KatelloUtils.getUniqueID();
        KatelloFilter filter = new KatelloFilter(filterName, this.org, null, "package1, package2");
        SSHCommandResult res = filter.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (filter create)");
        Assert.assertTrue((boolean)this.getOutput(res).equals(String.format("Successfully created filter [ %s ]", filterName)), (String)"Check - output string (filter create)");
        this.assert_filterInfo(filter);
    }

    @Test(description="List Filters", groups={"cli-filter"})
    public void test_listFilters() {
        ArrayList<KatelloFilter> filters = new ArrayList<KatelloFilter>();
        String uid = KatelloUtils.getUniqueID();
        String filterName = "filter1" + uid;
        KatelloFilter filter = new KatelloFilter(filterName, this.org, null, null);
        filter.create();
        filters.add(filter);
        String filterName2 = "filter2" + uid;
        KatelloFilter filter2 = new KatelloFilter(filterName2, this.org, null, null);
        filter2.create();
        filters.add(filter2);
        SSHCommandResult res = filter.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (filter list)");
        for (KatelloFilter flt : filters) {
            if (flt.description == null) {
                flt.description = "None";
            }
            String match_list = String.format(".*%s\\s+%s.*", flt.name, flt.description).replaceAll("\"", "");
            Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_list), (String)("Check - filter matches [" + flt.name + "]"));
        }
    }

    @Test(description="Delete a Filter", groups={"cli-filter"})
    public void test_deleteFilter() {
        String uid = KatelloUtils.getUniqueID();
        String filterName = "filter1" + uid;
        KatelloFilter filter = new KatelloFilter(filterName, this.org, null, null);
        filter.create();
        SSHCommandResult res = filter.delete();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully deleted filter [ %s ]", filter.name)), (String)"Check - return string");
        res = filter.cli_info();
        Assert.assertTrue((res.getExitCode() == 148 ? 1 : 0) != 0, (String)"Check - return code [148]");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)String.format("Couldn't find filter '%s'", filter.name));
    }

    @Test(description="Delete a Filter not exist", groups={"cli-filter"})
    public void test_deleteFilterNotFound() {
        String uid = KatelloUtils.getUniqueID();
        String filterName = "filter1" + uid;
        KatelloFilter filter = new KatelloFilter(filterName, this.org, null, null);
        SSHCommandResult res = filter.delete();
        Assert.assertTrue((res.getExitCode() == 148 ? 1 : 0) != 0, (String)"Check - return code [148]");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)String.format("Couldn't find filter '%s'", filter.name));
    }

    @Test(description="Info Filter not exist", groups={"cli-filter"})
    public void test_infoFilterNotFound() {
        String uid = KatelloUtils.getUniqueID();
        String filterName = "filter1" + uid;
        KatelloFilter filter = new KatelloFilter(filterName, this.org, null, null);
        SSHCommandResult res = filter.cli_info();
        Assert.assertTrue((res.getExitCode() == 148 ? 1 : 0) != 0, (String)"Check - return code [148]");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)String.format("Couldn't find filter '%s'", filter.name));
    }

    @Test(description="Add package to filter", groups={"cli-filter"})
    public void test_addPackage() {
        String filterName = "filter" + KatelloUtils.getUniqueID();
        KatelloFilter filter = new KatelloFilter(filterName, this.org, null, "package1");
        SSHCommandResult res = filter.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        res = filter.cli_addPackage("package2");
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).equals(String.format("Successfully added package [ %s ] to filter [ %s ]", "package2", filterName)), (String)"Check - output string (filter added package)");
        filter.packages = "package1, package2";
        this.assert_filterInfo(filter);
    }

    @Test(description="Add package to filter which does not exist", groups={"cli-filter"})
    public void test_addPackageNotFound() {
        String filterName = "filter" + KatelloUtils.getUniqueID();
        KatelloFilter filter = new KatelloFilter(filterName, this.org, null, "package1");
        SSHCommandResult res = filter.cli_addPackage("package2");
        Assert.assertTrue((res.getExitCode() == 148 ? 1 : 0) != 0, (String)"Check - return code [148]");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)String.format("Couldn't find filter '%s'", filter.name));
    }

    @Test(description="Remove package from filter", groups={"cli-filter"})
    public void test_removePackage() {
        String filterName = "filter" + KatelloUtils.getUniqueID();
        KatelloFilter filter = new KatelloFilter(filterName, this.org, null, "package1, package2");
        SSHCommandResult res = filter.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        res = filter.cli_removePackage("package2");
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).equals(String.format("Successfully removed package [ %s ] from filter [ %s ]", "package2", filterName)), (String)"Check - output string (filter removed package)");
        filter.packages = "package1";
        this.assert_filterInfo(filter);
    }

    @Test(description="Remove package from filter which does not exist", groups={"cli-filter"})
    public void test_removePackageNotFound() {
        String filterName = "filter" + KatelloUtils.getUniqueID();
        KatelloFilter filter = new KatelloFilter(filterName, this.org, null, "package1");
        SSHCommandResult res = filter.cli_removePackage("package1");
        Assert.assertTrue((res.getExitCode() == 148 ? 1 : 0) != 0, (String)"Check - return code [148]");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)String.format("Couldn't find filter '%s'", filter.name));
    }

    private void assert_filterInfo(KatelloFilter filter) {
        if (filter.description == null) {
            filter.description = "None";
        }
        if (filter.packages == null) {
            filter.packages = "";
        }
        SSHCommandResult res = filter.cli_info();
        String match_info = String.format(".*Name:\\s+%s.*Description:\\s+%s.*Package List:\\s+%s.*", filter.name, filter.description, filter.packages).replaceAll("\"", "");
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        log.finest(String.format("Filter (info) match regex: [%s]", match_info));
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Filter [%s] should be found in the result info", filter.name));
    }
}

