/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import javax.management.Attribute;

public class KatelloSyncPlan {
    public static final String CMD_CREATE = "sync_plan create";
    public static final String CMD_INFO = "sync_plan info";
    public static final String CMD_LIST = "sync_plan list";
    public static final String CMD_UPDATE = "sync_plan update";
    public static final String CMD_DELETE = "sync_plan delete";
    public static final String REG_SYNCPLAN_INFO = ".*Id:\\s+\\d+.*Name:\\s+%s.*Description:\\s+%s.*Start date:\\s+%s.*Interval:\\s+%s.*";
    public static final String REG_SYNCPLAN_LIST = ".*\\s+\\d+.*\\s+%s.*\\s+%s.*\\s+%s.*\\s+%s.*";
    public static final String ERR_NOT_FOUND = "Cannot find sync plan [ %s ]";
    public static final String OUT_DELETE = "Successfully deleted sync plan [ %s ]";
    public String name;
    public String org;
    public String description;
    public String date;
    public String time;
    public String interval = null;
    private KatelloCli cli;
    private ArrayList<Attribute> opts;

    public KatelloSyncPlan(String name, String org, String description, String date, String time, SyncPlanInterval interval) {
        this.name = name;
        this.org = org;
        this.description = description;
        this.date = date;
        this.time = time;
        if (interval != null) {
            this.interval = interval.toString();
        }
        this.opts = new ArrayList();
    }

    public SSHCommandResult create() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("description", this.description));
        this.opts.add(new Attribute("date", this.date));
        this.opts.add(new Attribute("time", this.time));
        this.opts.add(new Attribute("interval", this.interval));
        this.cli = new KatelloCli(CMD_CREATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_name(String newname) {
        this.opts.clear();
        this.opts.add(new Attribute("new_name", newname));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_date(String newdate, String newtime) {
        this.opts.clear();
        this.opts.add(new Attribute("date", newdate));
        this.opts.add(new Attribute("time", newtime));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_interval(SyncPlanInterval newinterval) {
        this.opts.clear();
        this.opts.add(new Attribute("interval", newinterval.toString()));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult info() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_INFO, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult list() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.cli = new KatelloCli(CMD_LIST, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_DELETE, this.opts);
        return this.cli.run();
    }

    public static enum SyncPlanInterval {
        none,
        hourly,
        daily,
        weekly;

    }
}

