/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloSystem;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import org.testng.SkipException;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-cli", "headpin-cli"})
public class SystemTests
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(SystemTests.class.getName());
    private SSHCommandResult exec_result;
    private String orgName;
    private String envName_Dev;
    private String envName_Test;

    @BeforeClass(description="Generate unique names")
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.orgName = "org-rhsm-" + uid;
        this.envName_Dev = "Dev-" + uid;
        this.envName_Test = "Test-" + uid;
        KatelloOrg org = new KatelloOrg(this.orgName, null);
        this.exec_result = org.cli_create();
        Assert.assertEquals((int)this.exec_result.getExitCode(), (int)0, (String)"Check - return code (org create)");
        Assert.assertTrue((boolean)this.exec_result.getStdout().trim().equals(String.format("Successfully created org [ %s ]", this.orgName)), (String)"Check - returned message");
        this.rhsm_clean();
        this.exec_result = KatelloUtils.sshOnClient(KatelloSystem.RHSM_CREATE);
        if (this.exec_result.getStderr().contains("certificate verify failed")) {
            log.warning("Seems your server uses its own certificate: RHSM tests can't run there - certificate issue");
            throw new SkipException("RHSM tests can not run on this specific server. Certificate issues.");
        }
        this.rhsm_clean();
    }

    @Test(description="RHSM register - org have no environment but Locker only", enabled=true)
    public void test_rhsm_RegLockerOnly() {
        KatelloSystem sys = new KatelloSystem("localhost" + KatelloUtils.getUniqueID(), this.orgName, null);
        this.exec_result = sys.rhsm_register();
        Assert.assertTrue((this.exec_result.getExitCode() == 255 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.exec_result.getStderr().trim(), (String)String.format("Organization %s has '%s' environment only. Please create an environment for system registration.", this.orgName, "Library"), (String)"Check - please create an env.");
    }

    @Test(description="RHSM register - one environment only", dependsOnMethods={"test_rhsm_RegLockerOnly"}, enabled=true)
    public void test_rhsm_RegOneEnvOnly() {
        String uid = KatelloUtils.getUniqueID();
        String system = "rhsm-reg-" + uid;
        KatelloEnvironment env = new KatelloEnvironment(this.envName_Dev, null, this.orgName, "Library");
        env.cli_create();
        KatelloSystem sys = new KatelloSystem(system, this.orgName, null);
        this.exec_result = sys.rhsm_register();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.exec_result.getStdout().trim().contains("The system has been registered with id:"), (String)"Check - output (success)");
    }

    @Test(description="RHSM register - already registered", dependsOnMethods={"test_rhsm_RegOneEnvOnly"}, enabled=true)
    public void test_rhsm_AlreadyReg() {
        String uid = KatelloUtils.getUniqueID();
        String system = "rhsm-reg1-" + uid;
        KatelloSystem sys = new KatelloSystem(system, this.orgName, null);
        this.exec_result = sys.rhsm_register();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.exec_result.getStdout().trim().contains("The system has been registered with id:"), (String)"Check - output (success)");
        system = "rhsm-reg2-" + uid;
        sys = new KatelloSystem(system, this.orgName, null);
        this.exec_result = sys.rhsm_register();
        Assert.assertTrue((this.exec_result.getExitCode() == 1 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.exec_result.getStdout().trim().contains("This system is already registered. Use --force to override"), (String)"Check - output (--force needed)");
    }

    @Test(description="RHSM force register", dependsOnMethods={"test_rhsm_AlreadyReg"}, enabled=true)
    public void test_rhsm_ForceReg() {
        String uid = KatelloUtils.getUniqueID();
        String system = "rhsm-force-" + uid;
        KatelloSystem sys = new KatelloSystem(system, this.orgName, null);
        this.exec_result = sys.rhsm_register();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.exec_result.getStdout().trim().contains("The system has been registered with id:"), (String)"Check - output (success)");
        this.exec_result = sys.rhsm_registerForce();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (register --force)");
        String REGEXP_UNREGISTERED = ".*The system with UUID .* has been unregistered.*";
        Assert.assertTrue((boolean)this.exec_result.getStdout().replaceAll("\n", "").matches(REGEXP_UNREGISTERED), (String)"Check - system is unregistered");
        Assert.assertTrue((boolean)this.exec_result.getStdout().trim().contains("The system has been registered with id:"), (String)"Check - output (system registered --force)");
    }

    @Test(description="RHSM register - more than one environment (no env. specified)", dependsOnMethods={"test_rhsm_ForceReg"}, enabled=true)
    public void test_rhsm_RegMultiEnv() {
        String uid = KatelloUtils.getUniqueID();
        String system = "rhsm-regMultiEnv-" + uid;
        KatelloEnvironment env = new KatelloEnvironment(this.envName_Test, null, this.orgName, "Library");
        env.cli_create();
        KatelloSystem sys = new KatelloSystem(system, this.orgName, null);
        this.exec_result = sys.rhsm_register();
        Assert.assertTrue((this.exec_result.getExitCode() == 255 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.exec_result.getStderr().trim().contains(String.format("Organization %s has more than one environment. Please specify target environment for system registration.", this.orgName)), (String)"Check - output (rhsm register - multi envs. exist)");
    }

    @Test(description="RHSM register - env specified", dependsOnMethods={"test_rhsm_RegMultiEnv"}, enabled=true)
    public void test_rhsm_RegWithEnv() {
        String uid = KatelloUtils.getUniqueID();
        String system = "rhsm-env-" + uid;
        KatelloSystem sys = new KatelloSystem(system, this.orgName, this.envName_Test);
        this.exec_result = sys.rhsm_register();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.exec_result.getStdout().trim().contains("The system has been registered with id:"), (String)"Check - output (success)");
    }

    @Test(description="RHSM register - same name for 2 environments", dependsOnMethods={"test_rhsm_RegMultiEnv"}, enabled=true)
    public void test_rhsm_RegSameNameTwoEnvs() {
        String uid = KatelloUtils.getUniqueID();
        String system = "localhost-" + uid;
        KatelloSystem sys = new KatelloSystem(system, this.orgName, this.envName_Dev);
        this.exec_result = sys.rhsm_register();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.exec_result.getStdout().trim().contains("The system has been registered with id:"), (String)"Check - output (success)");
        KatelloUtils.sshOnClient("subscription-manager clean");
        sys = new KatelloSystem(system, this.orgName, this.envName_Test);
        this.exec_result = sys.rhsm_register();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.exec_result.getStdout().trim().contains("The system has been registered with id:"), (String)"Check - output (success)");
        sys = new KatelloSystem(null, this.orgName, null);
        KatelloCli cli = new KatelloCli("system list --org " + this.orgName + " -v | grep \"" + system + "\" | wc -l", null);
        this.exec_result = cli.run();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (grep: `system list --org`)");
        Assert.assertTrue((boolean)this.exec_result.getStdout().replaceAll("\n", "").trim().equals("2"), (String)"Check - 2 systems are registered with the same name");
    }

    @AfterMethod(description="Clean RHSM data - prepare for next scenario run", alwaysRun=true)
    public void clean_rhsm() {
        KatelloUtils.sshOnClient("subscription-manager clean");
    }

    @AfterTest(description="erase registration made; cleanup", alwaysRun=true)
    public void tearDown() {
        KatelloUtils.sshOnClient("subscription-manager clean");
    }
}

