/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.base.obj.KatelloTemplate;
import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-cli"})
public class TemplateTests
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(TemplateTests.class.getName());
    private SSHCommandResult exec_result;
    private String templ_name;
    private String org_name;
    private String user_name;
    private String provider_name;
    private String product_name;
    private String repo_name;

    @BeforeClass(description="Generate unique objects")
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.org_name = "org" + uid;
        this.user_name = "user" + uid;
        this.provider_name = "provider" + uid;
        this.product_name = "product" + uid;
        this.repo_name = "repo" + uid;
        KatelloOrg org = new KatelloOrg(this.org_name, "Package tests");
        this.exec_result = org.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloUser user = new KatelloUser(this.user_name, "root@localhost", "testing", false);
        this.exec_result = user.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProvider prov = new KatelloProvider(this.provider_name, this.org_name, "Package provider", "http://inecas.fedorapeople.org/fakerepos/zoo3/");
        this.exec_result = prov.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod = new KatelloProduct(this.product_name, this.org_name, this.provider_name, null, null, null, null, null);
        this.exec_result = prod.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloRepo repo = new KatelloRepo(this.repo_name, this.org_name, this.product_name, "http://inecas.fedorapeople.org/fakerepos/zoo3/", null, null);
        this.exec_result = repo.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        prov.synchronize();
    }

    @Test(description="Create template", groups={"cli-template"})
    public void test_createTemplate() {
        KatelloTemplate templ = this.createTemplate();
        this.assert_templInfo(templ);
    }

    @Test(description="Create template and then list it", groups={"cli-template"})
    public void test_listTemplate() {
        KatelloTemplate templ = this.createTemplate();
        String templ_name2 = "template" + KatelloUtils.getUniqueID();
        KatelloTemplate tpl = new KatelloTemplate(templ_name2, null, this.org_name, null);
        this.exec_result = tpl.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.assert_templList(Arrays.asList(templ, tpl), new ArrayList<KatelloTemplate>());
    }

    @Test(description="Create template, than update template name", groups={"cli-template"})
    public void test_updateTemplateName() {
        KatelloTemplate templ = this.createTemplate();
        String oldName = templ.name;
        String newName = templ.name + "new";
        this.exec_result = templ.update_name(newName);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        templ.name = newName;
        this.assert_templInfo(templ);
        templ.name = oldName;
        this.exec_result = templ.info(null);
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Could not find template [ %s ] within environment [ %s ]", templ.name, "Library"));
    }

    @Test(description="Create template and add subtemplate to it", groups={"cli-template"})
    public void test_createSubTemplate() {
        KatelloTemplate templ = this.createTemplate();
        String id = this.assert_templInfo(templ);
        String templ_name2 = "template" + KatelloUtils.getUniqueID();
        KatelloTemplate tpl = new KatelloTemplate(templ_name2, "child template", this.org_name, this.templ_name);
        this.exec_result = tpl.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        tpl.parentId = id;
        this.assert_templInfo(tpl);
        this.assert_templList(Arrays.asList(templ, tpl), new ArrayList<KatelloTemplate>());
    }

    @Test(description="Create template and then delete it", groups={"cli-template"})
    public void test_deleteTemplate() {
        KatelloTemplate templ = this.createTemplate();
        String templ_name2 = "template" + KatelloUtils.getUniqueID();
        KatelloTemplate tpl = new KatelloTemplate(templ_name2, null, this.org_name, null);
        this.exec_result = tpl.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = templ.delete();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = templ.info(null);
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Could not find template [ %s ] within environment [ %s ]", templ.name, "Library"));
        this.assert_templList(Arrays.asList(tpl), Arrays.asList(templ));
    }

    @Test(description="Create template and add subtemplate to it and try to delete parent template, verify error", groups={"cli-template"})
    public void test_deleteParentTemplate() {
        KatelloTemplate templ = this.createTemplate();
        String templ_name2 = "template" + KatelloUtils.getUniqueID();
        KatelloTemplate tpl = new KatelloTemplate(templ_name2, "child template", this.org_name, this.templ_name);
        this.exec_result = tpl.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = templ.delete();
        Assert.assertTrue((this.exec_result.getExitCode() == 244 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)"The template has children templates.");
    }

    @Test(description="Create template which already exists, verify error", groups={"cli-template"})
    public void test_createTemplateExists() {
        KatelloTemplate templ = this.createTemplate();
        this.exec_result = templ.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 144 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)"Validation failed: Name has already been taken");
    }

    @Test(description="Create template, than add parameter to template", groups={"cli-template"})
    public void test_updateTemplateAddParam() {
        KatelloTemplate templ = this.createTemplate();
        String paramName = "testparam" + KatelloUtils.getUniqueID();
        String paramValue = "testparamval";
        this.exec_result = templ.update_add_param(paramName, "testparamval");
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated template [ %s ]", this.templ_name)), (String)"Check - output string (template update)");
        this.exec_result = templ.info(null);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(".*Parameters:\\s+.*%s:\\s+%s.*", paramName, "testparamval").replaceAll("\"", "");
        Pattern pattern = Pattern.compile(match_info);
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertTrue((boolean)matcher.find(), (String)"Check - Parameter should exist in template info");
    }

    @Test(description="Create template, than add parameter to template and then remove it", groups={"cli-template"})
    public void test_updateTemplateRemoveParam() {
        KatelloTemplate templ = this.createTemplate();
        String paramName = "testparam" + KatelloUtils.getUniqueID();
        String paramValue = "testparamval";
        this.exec_result = templ.update_add_param(paramName, "testparamval");
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated template [ %s ]", this.templ_name)), (String)"Check - output string (template update)");
        String paramName2 = "testparam2" + KatelloUtils.getUniqueID();
        String paramValue2 = "testparamval2";
        this.exec_result = templ.update_add_param(paramName2, "testparamval2");
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated template [ %s ]", this.templ_name)), (String)"Check - output string (template update)");
        this.exec_result = templ.update_remove_param(paramName2);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated template [ %s ]", this.templ_name)), (String)"Check - output string (template update)");
        this.exec_result = templ.info(null);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(".*Parameters:\\s+.*%s:\\s+%s.*", paramName2, "testparamval2").replaceAll("\"", "");
        Pattern pattern = Pattern.compile(match_info);
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertFalse((boolean)matcher.find(), (String)"Check - Parameter should not exist in template info");
    }

    @Test(description="Create template, than add package to template", groups={"cli-template"})
    public void test_updateTemplateAddPackage() {
        KatelloTemplate templ = this.createTemplate();
        String packageName = "lion";
        this.exec_result = templ.update_add_package(packageName);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated template [ %s ]", this.templ_name)), (String)"Check - output string (template update)");
        this.exec_result = templ.info(null);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(".*Packages:\\s+.*%s.*", packageName).replaceAll("\"", "");
        Pattern pattern = Pattern.compile(match_info);
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertTrue((boolean)matcher.find(), (String)"Check - Package should exist in template info");
    }

    @Test(description="Create template, than add package to template and then remove it", groups={"cli-template"})
    public void test_updateTemplateRemovePackage() {
        KatelloTemplate templ = this.createTemplate();
        String packageName = "lion";
        this.exec_result = templ.update_add_package(packageName);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated template [ %s ]", this.templ_name)), (String)"Check - output string (template update)");
        String packageName2 = "zebra";
        this.exec_result = templ.update_add_package(packageName2);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated template [ %s ]", this.templ_name)), (String)"Check - output string (template update)");
        this.exec_result = templ.update_remove_package(packageName);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated template [ %s ]", this.templ_name)), (String)"Check - output string (template update)");
        this.exec_result = templ.info(null);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(".*Packages:\\s+.*%s.*", packageName).replaceAll("\"", "");
        Pattern pattern = Pattern.compile(match_info);
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertFalse((boolean)matcher.find(), (String)"Check - Package should not exist in template info");
        match_info = String.format(".*Packages:\\s+.*%s.*", packageName2).replaceAll("\"", "");
        pattern = Pattern.compile(match_info);
        matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertTrue((boolean)matcher.find(), (String)"Check - Package should exist in template info");
    }

    @Test(description="Create template, than add package group to template", groups={"cli-template"})
    public void test_updateTemplateAddPackageGroup() {
        KatelloTemplate templ = this.createTemplate();
        String packageGroupName = "birds";
        this.exec_result = templ.update_add_package_group(packageGroupName);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated template [ %s ]", this.templ_name)), (String)"Check - output string (template update)");
        this.exec_result = templ.info(null);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(".*Package Groups:\\s+.*%s.*", packageGroupName).replaceAll("\"", "");
        Pattern pattern = Pattern.compile(match_info);
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertTrue((boolean)matcher.find(), (String)"Check - Package shoul Groupd exist in template info");
    }

    @Test(description="Create template, than add package group to template and then remove it", groups={"cli-template"})
    public void test_updateTemplateRemovePackageGroup() {
        KatelloTemplate templ = this.createTemplate();
        String packageGroupName = "birds";
        this.exec_result = templ.update_add_package_group(packageGroupName);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated template [ %s ]", this.templ_name)), (String)"Check - output string (template update)");
        String packageGroupName2 = "mammals";
        this.exec_result = templ.update_add_package_group(packageGroupName2);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated template [ %s ]", this.templ_name)), (String)"Check - output string (template update)");
        this.exec_result = templ.update_remove_package_group(packageGroupName);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated template [ %s ]", this.templ_name)), (String)"Check - output string (template update)");
        this.exec_result = templ.info(null);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(".*Package Groups:\\s+.*%s.*", packageGroupName).replaceAll("\"", "");
        Pattern pattern = Pattern.compile(match_info);
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertFalse((boolean)matcher.find(), (String)"Check - Package Group should not exist in template info");
        match_info = String.format(".*Package Groups:\\s+.*%s.*", packageGroupName2).replaceAll("\"", "");
        pattern = Pattern.compile(match_info);
        matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertTrue((boolean)matcher.find(), (String)"Check - Package Group should exist in template info");
    }

    @Test(description="Create template, than add repository to template", groups={"cli-template"})
    public void test_updateTemplateAddRepo() {
        KatelloTemplate templ = this.createTemplate();
        this.exec_result = templ.update_add_repo(this.product_name, this.repo_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated template [ %s ]", this.templ_name)), (String)"Check - output string (template update)");
        this.exec_result = templ.info(null);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(".*Repositories:\\s+.*%s.*", this.repo_name).replaceAll("\"", "");
        Pattern pattern = Pattern.compile(match_info);
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertTrue((boolean)matcher.find(), (String)"Check - Repository should exist in template info");
    }

    @Test(description="Create template, than add repository to template and then remove it", groups={"cli-template"})
    public void test_updateTemplateRemoveRepo() {
        KatelloTemplate templ = this.createTemplate();
        this.exec_result = templ.update_add_repo(this.product_name, this.repo_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated template [ %s ]", this.templ_name)), (String)"Check - output string (template update)");
        this.exec_result = templ.update_remove_repo(this.product_name, this.repo_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated template [ %s ]", this.templ_name)), (String)"Check - output string (template update)");
        this.exec_result = templ.info(null);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(".*Repositories:\\s+.*%s.*", this.repo_name).replaceAll("\"", "");
        Pattern pattern = Pattern.compile(match_info);
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertFalse((boolean)matcher.find(), (String)"Check - Repository should not exist in template info");
    }

    private String assert_templInfo(KatelloTemplate templ) {
        if (templ.description == null) {
            templ.description = "None";
        }
        if (templ.parentId == null) {
            templ.parentId = "None";
        }
        if (templ.revision == null) {
            templ.revision = "1";
        }
        this.exec_result = templ.info(null);
        String match_info = String.format(".*Id:\\s+\\d+.*Name:\\s+%s.*Revision:\\s+%s.*Description:\\s+%s.*Parent Id:\\s+%s.*", templ.name, templ.revision, templ.description, templ.parentId).replaceAll("\"", "");
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        log.finest(String.format("Template (info) match regex: [%s]", match_info));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("Template [%s] should be found in the result info", templ.name));
        Pattern pattern = Pattern.compile("Id:\\s+\\d+.*Name:");
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertTrue((boolean)matcher.find(), (String)"Check - Id should exist in template info");
        String id = matcher.group();
        id = id.replace("Id:", "").replace("Name:", "").trim();
        return id;
    }

    private void assert_templList(List<KatelloTemplate> templates, List<KatelloTemplate> excludeTemplates) {
        String match_info;
        this.exec_result = new KatelloTemplate(this.templ_name, null, this.org_name, null).list();
        for (KatelloTemplate templ : templates) {
            if (templ.description == null) {
                templ.description = "None";
            }
            if (templ.parentId == null) {
                templ.parentId = "None";
            }
            match_info = String.format(".*\\s+\\d+.*\\s+%s.*\\s+%s.*\\s+%s.*", templ.name, templ.description, templ.parentId).replaceAll("\"", "");
            Assert.assertTrue((boolean)this.getOutput(this.exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("Template [%s] should be found in the result list", templ.name));
        }
        for (KatelloTemplate templ : excludeTemplates) {
            if (templ.description == null) {
                templ.description = "None";
            }
            if (templ.parentId == null) {
                templ.parentId = "None";
            }
            match_info = String.format(".*\\s+\\d+.*\\s+%s.*\\s+%s.*\\s+%s.*", templ.name, templ.description, templ.parentId).replaceAll("\"", "");
            Assert.assertFalse((boolean)this.getOutput(this.exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("Template [%s] should be found in the result list", templ.name));
        }
    }

    private KatelloTemplate createTemplate() {
        this.templ_name = "template" + KatelloUtils.getUniqueID();
        KatelloTemplate tpl = new KatelloTemplate(this.templ_name, null, this.org_name, null);
        this.exec_result = tpl.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).equals(String.format("Successfully created template [ %s ]", this.templ_name)), (String)"Check - output string (template create)");
        return tpl;
    }
}

