/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.upgrade.v1;

import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.common.KatelloUtils;
import java.util.logging.Logger;
import org.testng.annotations.Test;

public class KatelloUpgrade
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(KatelloUpgrade.class.getName());
    public static final String UPGRADE_REPO_LATEST = "http://download.lab.bos.redhat.com/rel-eng/CloudForms/1.0.1/latest/el6-se/x86_64/";

    @Test(description="prepare the upgrade yum repo", dependsOnGroups={"pre-upgrade"}, groups={"upgrade"})
    public void installYumRepo() {
        String upgradeRepo = System.getProperty("katello.upgrade.repo", UPGRADE_REPO_LATEST);
        String _yumrepo = "[cfse-upgrade]\\\\nname=System Engine Upgrade\\\\nbaseurl=" + upgradeRepo + "\\\\n" + "enabled=1\\\\n" + "skip_if_unavailable=1\\\\n" + "gpgcheck=0";
        KatelloUtils.sshOnServer("echo -en \"" + _yumrepo + "\" > /etc/yum.repos.d/cfse-upgrade.repo");
    }

    @Test(description="stop services", dependsOnMethods={"installYumRepo"}, dependsOnGroups={"pre-upgrade"}, groups={"upgrade"})
    public void stopServices() {
        KatelloUtils.stopKatello();
    }

    @Test(description="update rpms", dependsOnMethods={"stopServices"}, dependsOnGroups={"pre-upgrade"}, groups={"upgrade"})
    public void updateRpms() {
        KatelloUtils.sshOnServer("yum -y update pulp* candlepin* katello*");
    }

    @Test(description="run schema upgrade", dependsOnMethods={"updateRpms"}, dependsOnGroups={"pre-upgrade"}, groups={"upgrade"})
    public void runUpgrade() {
        KatelloUtils.sshOnServer("katello-upgrade -y");
    }

    @Test(description="start services", dependsOnMethods={"runUpgrade"}, dependsOnGroups={"pre-upgrade"}, groups={"upgrade"})
    public void startServices() {
        KatelloUtils.startKatello();
    }
}

