/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import javax.management.Attribute;

public class KatelloTemplate {
    public static final String CMD_CREATE = "template create";
    public static final String CMD_DELETE = "template delete";
    public static final String CMD_LIST = "template list";
    public static final String CMD_INFO = "template info -v";
    public static final String CMD_UPDATE = "template update";
    public static final String CMD_EXPORT = "template export";
    public static final String FORMAT_TDL = "tdl";
    public static final String ERR_TEMPL_NOTFOUND = "Could not find template [ %s ] within environment [ %s ]";
    public static final String REG_TEMPL_INFO = ".*Id:\\s+\\d+.*Name:\\s+%s.*Revision:\\s+%s.*Description:\\s+%s.*Parent Id:\\s+%s.*";
    public static final String REG_TEMPL_PARAMS = ".*Parameters:\\s+.*%s:\\s+%s.*";
    public static final String REG_TEMPL_PACKAGES = ".*Packages:\\s+.*%s.*";
    public static final String REG_TEMPL_PACKAGEGROUPS = ".*Package Groups:\\s+.*%s.*";
    public static final String REG_TEMPL_REPOS = ".*Repositories:\\s+.*%s.*";
    public static final String REG_TEMPL_LIST = ".*\\s+\\d+.*\\s+%s.*\\s+%s.*\\s+%s.*";
    public static final String REG_TEMPL_ID = "Id:\\s+\\d+.*Name:";
    public static final String OUT_CREATE = "Successfully created template [ %s ]";
    public static final String OUT_UPDATE = "Successfully updated template [ %s ]";
    public String name;
    public String org;
    public String description;
    public String parent;
    public String parentId;
    public String revision;
    private KatelloCli cli;
    private ArrayList<Attribute> opts;

    public KatelloTemplate(String pName, String pDesc, String pOrg, String pParent) {
        this.name = pName;
        this.description = pDesc;
        this.org = pOrg;
        this.parent = pParent;
        this.opts = new ArrayList();
    }

    public SSHCommandResult create() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", this.description));
        this.opts.add(new Attribute("parent", this.parent));
        this.cli = new KatelloCli(CMD_CREATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult info(String environment) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", environment));
        this.cli = new KatelloCli(CMD_INFO, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_DELETE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult list() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.cli = new KatelloCli(CMD_LIST, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_add_distribution(String product, String distribution) {
        this.opts.clear();
        this.opts.add(new Attribute("from_product", product));
        this.opts.add(new Attribute("add_distribution", distribution));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_add_repo(String product, String repo) {
        this.opts.clear();
        this.opts.add(new Attribute("from_product", product));
        this.opts.add(new Attribute("add_repository", repo));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_remove_repo(String product, String repo) {
        this.opts.clear();
        this.opts.add(new Attribute("from_product", product));
        this.opts.add(new Attribute("remove_repository", repo));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_add_package(String pkg) {
        this.opts.clear();
        this.opts.add(new Attribute("add_package", pkg));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_remove_package(String pkg) {
        this.opts.clear();
        this.opts.add(new Attribute("remove_package", pkg));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_add_param(String param, String value) {
        this.opts.clear();
        this.opts.add(new Attribute("add_param", param));
        this.opts.add(new Attribute("value", value));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_remove_param(String param) {
        this.opts.clear();
        this.opts.add(new Attribute("remove_param", param));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_name(String newname) {
        this.opts.clear();
        this.opts.add(new Attribute("new_name", newname));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_add_package_group(String pkgGrp) {
        this.opts.clear();
        this.opts.add(new Attribute("add_package_group", pkgGrp));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_remove_package_group(String pkgGrp) {
        this.opts.clear();
        this.opts.add(new Attribute("remove_package_group", pkgGrp));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult export(String environment, String file, String format) {
        this.opts.clear();
        this.opts.add(new Attribute("file", file));
        this.opts.add(new Attribute("format", format));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("environment", environment));
        this.cli = new KatelloCli(CMD_EXPORT, this.opts);
        return this.cli.run();
    }
}

