/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.ssl;

import com.redhat.qe.katello.ssl.KatelloPemThreadLocal;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509ExtendedKeyManager;
import net.oauth.signature.pem.PEMReader;
import net.oauth.signature.pem.PKCS1EncodedKeySpec;

public class PEMx509KeyManager
extends X509ExtendedKeyManager {
    protected Logger log = Logger.getLogger(PEMx509KeyManager.class.getName());
    private Set<String> aliases = new HashSet<String>();
    private Map<String, PrivateKey> privateKeys = new HashMap<String, PrivateKey>();
    private Map<String, X509Certificate[]> certificateChains = new HashMap<String, X509Certificate[]>();

    public void addPEM(String certificate, String privateKey) throws GeneralSecurityException, IOException {
        X509Certificate[] certificateChain = new X509Certificate[]{this.getX509CertificateFromPem(certificate)};
        PrivateKey thePrivateKey = this.getPrivateKeyFromPem(privateKey);
        String alias = certificateChain[0].getSubjectDN().getName();
        this.aliases.add(alias);
        this.privateKeys.put(alias, thePrivateKey);
        this.certificateChains.put(alias, certificateChain);
        this.log.finer("cert info! " + certificateChain[0].getSubjectDN().getName());
    }

    private PrivateKey getPrivateKeyFromPem(String pem) throws GeneralSecurityException, IOException {
        KeySpec keySpec;
        ByteArrayInputStream stream = new ByteArrayInputStream(pem.getBytes("UTF-8"));
        PEMReader reader = new PEMReader((InputStream)stream);
        byte[] bytes = reader.getDerBytes();
        if ("-----BEGIN RSA PRIVATE KEY-----".equals(reader.getBeginMarker())) {
            keySpec = new PKCS1EncodedKeySpec(bytes).getKeySpec();
        } else if ("-----BEGIN PRIVATE KEY-----".equals(reader.getBeginMarker())) {
            keySpec = new PKCS8EncodedKeySpec(bytes);
        } else {
            throw new IOException("Invalid PEM file: Unknown marker for private key " + reader.getBeginMarker());
        }
        KeyFactory fac = KeyFactory.getInstance("RSA");
        return fac.generatePrivate(keySpec);
    }

    private X509Certificate getX509CertificateFromPem(String pem) throws GeneralSecurityException, IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(pem.getBytes("UTF-8"));
        PEMReader reader = new PEMReader((InputStream)stream);
        byte[] bytes = reader.getDerBytes();
        if (!"-----BEGIN CERTIFICATE-----".equals(reader.getBeginMarker())) {
            throw new IOException("Invalid PEM file: Unknown marker for  public key or cert " + reader.getBeginMarker());
        }
        CertificateFactory fac = CertificateFactory.getInstance("X509");
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        X509Certificate cert = (X509Certificate)fac.generateCertificate(in);
        return cert;
    }

    private String getClientAlias() {
        String pem = KatelloPemThreadLocal.get();
        if (pem == null) {
            return null;
        }
        String alias = null;
        X509Certificate[] certificateChain = new X509Certificate[1];
        try {
            certificateChain[0] = this.getX509CertificateFromPem(pem);
            alias = certificateChain[0].getSubjectDN().getName();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.log.info("client alias: " + alias);
        return alias;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.getClientAlias();
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        this.log.fine("returning x509 certificate");
        return this.certificateChains.get(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.aliases.toArray(new String[this.aliases.size()]);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.privateKeys.get(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return null;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        try {
            engine.getSession().invalidate();
            engine.beginHandshake();
        }
        catch (SSLException e) {
            e.printStackTrace();
        }
        return this.getClientAlias();
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return null;
    }
}

