/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliDataProvider;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloClient;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import org.testng.annotations.Test;

@Test(groups={"headpin-cli"})
public class ClientTests
extends KatelloCliTestScript {
    private SSHCommandResult exec_result;

    @Test(description="Saved_options list options saved in the client config")
    public void test_SavedOptions() {
        KatelloClient client_obj = new KatelloClient();
        this.exec_result = client_obj.cli_saved_options();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
    }

    @Test(description="forget : remove an option from the client config")
    public void test_Forget() {
        String uid = KatelloUtils.getUniqueID();
        String option = "op-" + uid;
        String value = "val-" + uid;
        KatelloClient client_obj = new KatelloClient(option, value);
        this.exec_result = client_obj.cli_remember();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (client remember)");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully remembered option [ %s ]", option)), (String)"Check - returned output string (client remember)");
        this.exec_result = client_obj.cli_forget();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (client forget)");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully forgot option [ %s ]", option)), (String)"Check - returned output string (client forget)");
    }

    @Test(description="Client Remember", groups={"headpin-cli"}, dataProvider="client_remember", dataProviderClass=KatelloCliDataProvider.class, enabled=true)
    public void testClient_Remember(String option, String value, Integer exitCode, String output) {
        KatelloClient client_obj = new KatelloClient(option, value);
        SSHCommandResult exec_result = client_obj.cli_remember();
        Assert.assertTrue((exec_result.getExitCode().intValue() == exitCode.intValue() ? 1 : 0) != 0, (String)"Check - return code");
        if (exitCode == 0) {
            Assert.assertTrue((boolean)this.getOutput(exec_result).contains(output), (String)"Check - returned output string");
        } else {
            Assert.assertTrue((boolean)this.getOutput(exec_result).contains(output), (String)"Check - returned error string");
        }
    }
}

