/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.grapher.GrapherModule;
import com.google.inject.grapher.InjectorGrapher;
import com.google.inject.grapher.graphviz.GraphvizModule;
import com.google.inject.grapher.graphviz.GraphvizRenderer;
import com.redhat.qe.katello.base.KatelloApiException;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloEntitlement;
import com.redhat.qe.katello.base.obj.KatelloSystem;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.katello.guice.CertSSLContext;
import com.redhat.qe.katello.guice.KatelloApiModule;
import com.redhat.qe.katello.guice.PlainSSLContext;
import com.redhat.qe.katello.ssl.KatelloPemThreadLocal;
import com.redhat.qe.katello.ssl.PEMx509KeyManager;
import com.redhat.qe.katello.tasks.KatelloTasks;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.GeneralSecurityException;
import java.util.List;
import org.testng.annotations.Test;

public class DemoKatelloApi
extends KatelloTestScript {
    @Inject
    Injector injector;
    @Inject
    PEMx509KeyManager keyManager;

    @Test(description="demo new RestEasy API")
    public void test_resteasy_api() {
        String hostname = "host" + KatelloUtils.getUniqueID() + ".example.com";
        String uuid = KatelloUtils.getUUID();
        try {
            for (int i = 0; i < 2; ++i) {
                KatelloTasks tasks = (KatelloTasks)this.injector.getInstance(Key.get(KatelloTasks.class, PlainSSLContext.class));
                KatelloTasks tasksWithCert = (KatelloTasks)this.injector.getInstance(Key.get(KatelloTasks.class, CertSSLContext.class));
                KatelloSystem consumer = tasks.createConsumer("ACME_Corporation", hostname, uuid);
                KatelloPemThreadLocal.set(consumer.getIdCert().getCert() + consumer.getIdCert().getKey());
                try {
                    this.keyManager.addPEM(consumer.getIdCert().getCert(), consumer.getIdCert().getKey());
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                KatelloSystem _return = tasksWithCert.updatePackages(consumer);
                this.log.info("Return cert is: " + _return.getIdCert().getCert());
                String[] aliases = this.keyManager.getClientAliases("", null);
                for (int j = 0; j < aliases.length; ++j) {
                    this.log.fine(aliases[j]);
                }
                List<KatelloEntitlement> subret = tasksWithCert.subscribeConsumerWithProduct(_return.getUuid(), new String[]{"rhel6-server"});
                KatelloPemThreadLocal.unset();
            }
        }
        catch (KatelloApiException e) {
            e.printStackTrace();
        }
    }

    private static void graph(String filename, Injector demoInjector) throws IOException {
        PrintWriter out = new PrintWriter(new File(filename), "UTF-8");
        Injector injector = Guice.createInjector((Module[])new Module[]{new GrapherModule(), new GraphvizModule()});
        GraphvizRenderer renderer = (GraphvizRenderer)injector.getInstance(GraphvizRenderer.class);
        renderer.setOut(out).setRankdir("TB");
        ((InjectorGrapher)injector.getInstance(InjectorGrapher.class)).of(demoInjector).graph();
    }

    public static void main(String[] args) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new KatelloApiModule()});
        KatelloTasks tasks = (KatelloTasks)injector.getInstance(Key.get(KatelloTasks.class, CertSSLContext.class));
        try {
            tasks.getOrganizations();
        }
        catch (KatelloApiException e) {
            e.printStackTrace();
        }
    }
}

