/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.tools;

import com.redhat.qe.Assert;
import com.redhat.qe.jul.TestRecords;
import com.redhat.qe.tools.SSHCommandResult;
import com.redhat.qe.tools.SSHCommandRunner;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class RemoteFileTasks {
    protected static Logger log = Logger.getLogger(RemoteFileTasks.class.getName());

    public static void createFile(Connection conn, String filePath, String contents, String mode) throws IOException {
        String dir = new File(filePath).getParent();
        String fn = new File(filePath).getName();
        log.log(Level.INFO, "Creating " + fn + " in " + dir + " on " + conn.getHostname(), TestRecords.Style.Action);
        SCPClient scp = new SCPClient(conn);
        scp.put(contents.getBytes(), fn, dir, mode);
    }

    public static void createFile(Connection conn, String filePath, String contents) throws IOException {
        RemoteFileTasks.createFile(conn, filePath, contents, "0755");
    }

    public static int createFile(SSHCommandRunner runner, String filePath, String contents, String perms) {
        int exitCode = RemoteFileTasks.runCommandAndWait(runner, "echo -n -e '" + contents + "' > " + filePath, TestRecords.action());
        if (exitCode == 0 && perms != null) {
            exitCode = RemoteFileTasks.runCommandAndWait(runner, "chmod " + perms + " " + filePath, TestRecords.action());
        }
        return exitCode;
    }

    public static void putFiles(Connection conn, String destDir, String ... sources) throws IOException {
        for (String source : sources) {
            log.log(Level.INFO, "Copying " + source + " to " + destDir + " on " + conn.getHostname(), TestRecords.Style.Action);
        }
        SCPClient scp = new SCPClient(conn);
        scp.put(sources, destDir);
    }

    public static void putFile(Connection conn, String source, String dest, String mask) throws IOException {
        log.log(Level.INFO, "Copying local file " + source + " to " + dest + " on " + conn.getHostname() + " with mask " + mask, TestRecords.Style.Action);
        SCPClient scp = new SCPClient(conn);
        if (dest.endsWith("/")) {
            scp.put(new String[]{source}, null, dest, mask);
        } else {
            String destDir = new File(dest).getParentFile().getCanonicalPath();
            String destFile = new File(dest).getName();
            scp.put(new String[]{source}, new String[]{destFile}, destDir, mask);
        }
    }

    public static void getFiles(Connection conn, String localTargetDirectory, String ... remoteFiles) throws IOException {
        for (String remoteFile : remoteFiles) {
            log.log(Level.INFO, "Copying remote file " + remoteFile + " on " + conn.getHostname() + " to local directory " + localTargetDirectory + ".", TestRecords.Style.Action);
        }
        SCPClient scp = new SCPClient(conn);
        scp.get(remoteFiles, localTargetDirectory);
    }

    public static void getFile(Connection conn, String localTargetDirectory, String remoteFile) throws IOException {
        RemoteFileTasks.getFiles(conn, localTargetDirectory, remoteFile);
    }

    public static int searchReplaceFile(SSHCommandRunner runner, String filePath, String regexp, String replacement) {
        return RemoteFileTasks.runCommandAndWait(runner, "sed -i 's/" + regexp + "/" + replacement + "/g' " + filePath, TestRecords.action());
    }

    public static int grepFile(SSHCommandRunner runner, String filePath, String pattern) {
        return RemoteFileTasks.runCommandAndWait(runner, "grep -E '" + pattern + "' " + filePath, TestRecords.info());
    }

    public static int deleteLines(SSHCommandRunner runner, String filePath, String containingText) {
        return RemoteFileTasks.runCommandAndWait(runner, "sed -i '/" + containingText + "/d' " + filePath, TestRecords.action());
    }

    public static int markFile(SSHCommandRunner runner, String filePath, String marker) {
        if (!RemoteFileTasks.testExists(runner, filePath)) {
            return 1;
        }
        return RemoteFileTasks.runCommandAndWait(runner, "echo '" + marker + "' >> " + filePath, TestRecords.action());
    }

    public static String getTailFromMarkedFile(SSHCommandRunner runner, String filePath, String marker, String grepPattern) {
        if (grepPattern != null) {
            return RemoteFileTasks.runCommandAndAssert(runner, "(TAIL=''; IFS=$'\\n'; for line in $(egrep '" + grepPattern + "|" + marker + "' " + filePath + " | tac); do if [[ $line = '" + marker + "' ]]; then break; fi; if [[ $TAIL = '' ]]; then TAIL=$line; else TAIL=$line'\\n'${TAIL}; fi; done; echo -e $TAIL)", 0).getStdout();
        }
        return RemoteFileTasks.runCommandAndAssert(runner, "(TAIL=''; IFS=$'\\n'; for line in $(tac " + filePath + "); do if [[ $line = '" + marker + "' ]]; then break; fi; if [[ $TAIL = '' ]]; then TAIL=$line; else TAIL=$line'\\n'${TAIL}; fi; done; echo -e $TAIL)", 0).getStdout();
    }

    @Deprecated
    public static int testFileExists(SSHCommandRunner runner, String filePath) {
        RemoteFileTasks.runCommandAndWait(runner, "test -e " + filePath + " && echo 1 || echo 0", TestRecords.info());
        if (runner.getStdout().trim().equals("1")) {
            return 1;
        }
        if (runner.getStdout().trim().equals("0")) {
            return 0;
        }
        return -1;
    }

    public static boolean testExists(SSHCommandRunner runner, String filePath) {
        SSHCommandResult result = runner.runCommandAndWait("test -e " + filePath);
        return result.exitCode == 0;
    }

    public static int runCommandAndWait(SSHCommandRunner runner, String command, LogRecord logRecord) {
        return runner.runCommandAndWait(command, logRecord).getExitCode();
    }

    public static int runAugeasCommand(SSHCommandRunner runner, String command, LogRecord logRecord) {
        return RemoteFileTasks.runCommandAndWait(runner, String.format("echo -e \"%s\nsave\" | augtool", command), logRecord);
    }

    public static int updateAugeasConfig(SSHCommandRunner runner, String augeusPath, String newValue) {
        if (newValue == null) {
            return RemoteFileTasks.runAugeasCommand(runner, String.format("rm %s", augeusPath), TestRecords.action());
        }
        return RemoteFileTasks.runAugeasCommand(runner, String.format("set %s '%s'", augeusPath, newValue), TestRecords.action());
    }

    public static SSHCommandResult runCommandAndAssert(SSHCommandRunner sshCommandRunner, String command, Integer exitCode, List<String> stdoutRegexs, List<String> stderrRegexs) {
        ArrayList<Integer> exitCodes = null;
        if (exitCode != null) {
            exitCodes = new ArrayList<Integer>();
            exitCodes.add(exitCode);
        }
        return RemoteFileTasks.runCommandAndAssert(sshCommandRunner, command, exitCodes, stdoutRegexs, stderrRegexs);
    }

    public static SSHCommandResult runCommandAndAssert(SSHCommandRunner sshCommandRunner, String command, List<Integer> validExitCodes, List<String> stdoutRegexs, List<String> stderrRegexs) {
        SSHCommandResult sshCommandResult = sshCommandRunner.runCommandAndWait(command);
        if (validExitCodes != null) {
            Assert.assertContains(validExitCodes, (Object)sshCommandResult.getExitCode());
        }
        if (stdoutRegexs != null) {
            for (String regex : stdoutRegexs) {
                Assert.assertContainsMatch((String)sshCommandResult.getStdout(), (String)regex, (String)"Stdout", (String)String.format("Stdout from command '%s' contains matches to regex '%s',", command, regex));
            }
        }
        if (stderrRegexs != null) {
            for (String regex : stderrRegexs) {
                Assert.assertContainsMatch((String)sshCommandResult.getStderr(), (String)regex, (String)"Stderr", (String)String.format("Stderr from command '%s' contains matches to regex '%s',", command, regex));
            }
        }
        return sshCommandResult;
    }

    public static SSHCommandResult runCommandAndAssert(SSHCommandRunner sshCommandRunner, String command, Integer exitCode, String stdoutRegex, String stderrRegex) {
        ArrayList<String> stdoutRegexs = null;
        if (stdoutRegex != null) {
            stdoutRegexs = new ArrayList<String>();
            stdoutRegexs.add(stdoutRegex);
        }
        ArrayList<String> stderrRegexs = null;
        if (stderrRegex != null) {
            stderrRegexs = new ArrayList<String>();
            stderrRegexs.add(stderrRegex);
        }
        return RemoteFileTasks.runCommandAndAssert(sshCommandRunner, command, exitCode, stdoutRegexs, stderrRegexs);
    }

    public static SSHCommandResult runCommandAndAssert(SSHCommandRunner sshCommandRunner, String command, Integer ... exitCodes) {
        return RemoteFileTasks.runCommandAndAssert(sshCommandRunner, command, Arrays.asList(exitCodes), new ArrayList<String>(), new ArrayList<String>());
    }

    public static SSHCommandResult runCommandExpectingNonzeroExit(SSHCommandRunner sshCommandRunner, String command) {
        return RemoteFileTasks.runCommandExpectingNonzeroExit(sshCommandRunner, command, null);
    }

    public static SSHCommandResult runCommandExpectingNonzeroExit(SSHCommandRunner sshCommandRunner, String command, Long timeout) {
        SSHCommandResult sshCommandResult = sshCommandRunner.runCommandAndWait(command, timeout);
        Assert.assertTrue((!sshCommandResult.getExitCode().equals(0) ? 1 : 0) != 0, (String)("Command '" + command + "' returns nonzero error code: " + sshCommandResult.getExitCode()));
        return sshCommandResult;
    }

    public static SSHCommandResult runCommandExpectingNoTracebacks(SSHCommandRunner sshCommandRunner, String command) {
        return RemoteFileTasks.runCommandExpectingNoTracebacks(sshCommandRunner, command, null);
    }

    public static SSHCommandResult runCommandExpectingNoTracebacks(SSHCommandRunner sshCommandRunner, String command, Long timeout) {
        SSHCommandResult sshCommandResult = sshCommandRunner.runCommandAndWait(command, timeout);
        Assert.assertFalse((boolean)sshCommandResult.getStdout().toLowerCase().contains("traceback"), (String)"Traceback string not in stdout");
        Assert.assertFalse((boolean)sshCommandResult.getStderr().toLowerCase().contains("traceback"), (String)"Traceback string not in stderr");
        return sshCommandResult;
    }
}

