/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.tools;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SCPTools {
    protected String userName;
    protected File sshPemFile;
    protected String password;
    protected String server;
    protected static Logger log = Logger.getLogger(SCPTools.class.getName());
    protected Connection connection = null;
    protected SCPClient client = null;

    public SCPTools(String server, String user, File sshPemFile, String password) {
        this.userName = user;
        this.sshPemFile = sshPemFile;
        this.password = password;
        this.server = server;
    }

    public SCPTools(String server, String user, String sshPemFileLoc, String password) {
        this.userName = user;
        this.sshPemFile = new File(sshPemFileLoc);
        this.password = password;
        this.server = server;
    }

    public boolean sendFile(String source, String dest) {
        log.info("SCP: Copying " + source + " to " + this.server + ":" + dest);
        try {
            this.init();
            this.client.put(source, dest);
        }
        catch (IOException e) {
            log.log(Level.INFO, "SCP: File transfer failed:", e);
            return false;
        }
        log.info("SCP: Transfer succeeded");
        return true;
    }

    public boolean getFile(String remoteFile, String target) {
        log.info("SCP: Copying " + this.server + ":" + remoteFile + " to " + target);
        try {
            this.init();
            this.client.get(remoteFile, target);
        }
        catch (IOException e) {
            log.log(Level.INFO, "SCP: File transfer failed:", e);
            return false;
        }
        log.info("SCP: Transfer succeeded");
        return true;
    }

    public void close() {
        this.connection.close();
    }

    private void init() throws IOException {
        if (this.connection == null) {
            this.connection = this.connect_server();
            this.client = new SCPClient(this.connection);
        }
    }

    private Connection connect_server() throws IOException {
        Connection newConn = new Connection(this.server);
        try {
            newConn.connect();
            newConn.authenticateWithPublicKey(this.userName, this.sshPemFile, this.password);
        }
        catch (IOException e) {
            newConn = new Connection(this.server);
            try {
                newConn.connect();
            }
            catch (IOException ioe) {
                log.log(Level.INFO, "SCP: Connection failed:", ioe);
            }
            newConn.authenticateWithPassword(this.userName, this.password);
        }
        return newConn;
    }

    public static void main(String ... args) {
        SCPTools copier = new SCPTools("f14-1.usersys.redhat.com", "root", new File(""), "dog8code");
        copier.sendFile("/tmp/blah1", "/tmp/");
        copier.sendFile("/tmp/blah2", "/tmp");
        copier.sendFile("/tmp/blah3", "/tmp");
        copier.sendFile("/tmp/blah4", "/tmp");
        copier.sendFile("/tmp/blah5", "/tmp");
        copier.sendFile("/tmp/blah6", "/tmp");
        copier.sendFile("/tmp/blah7", "/tmp");
        copier.sendFile("/tmp/blah8", "/tmp");
        copier.sendFile("/tmp/blah9", "/tmp");
        copier.sendFile("/tmp/blah1", "/tmp/");
        copier.sendFile("/tmp/blah2", "/tmp");
        copier.sendFile("/tmp/blah3", "/tmp");
        copier.sendFile("/tmp/blah4", "/tmp");
        copier.sendFile("/tmp/blah5", "/tmp");
        copier.sendFile("/tmp/blah6", "/tmp");
        copier.sendFile("/tmp/blah7", "/tmp");
        copier.sendFile("/tmp/blah8", "/tmp");
        copier.sendFile("/tmp/blah9", "/tmp");
    }
}

