/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.tools;

import com.redhat.qe.jul.TestRecords;
import com.redhat.qe.tools.SSHCommandResult;
import com.redhat.qe.tools.SplitStreamLogger;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class SSHCommandRunner
implements Runnable {
    protected Connection connection;
    protected String user;
    protected Session session;
    protected InputStream out;
    protected static Logger log = Logger.getLogger(SSHCommandRunner.class.getName());
    protected InputStream err;
    protected String s_out;
    protected String s_err;
    protected boolean kill;
    protected String command;
    protected Object lock;

    public SSHCommandRunner(Connection connection, String command) {
        this.user = null;
        this.s_out = null;
        this.s_err = null;
        this.kill = false;
        this.command = null;
        this.lock = new Object();
        this.connection = connection;
        this.command = command;
    }

    public SSHCommandRunner(String server, String user, File sshPemFile, String passphrase, String command) throws IOException {
        this.user = null;
        this.s_out = null;
        this.s_err = null;
        this.kill = false;
        this.command = null;
        this.lock = new Object();
        Connection newConn = new Connection(server);
        newConn.connect();
        if (!newConn.authenticateWithPublicKey(user, sshPemFile, passphrase)) {
            throw new RuntimeException("Could not log in to " + newConn.getHostname() + " with the given credentials (" + user + ").");
        }
        this.connection = newConn;
        this.user = user;
        this.command = command;
    }

    public SSHCommandRunner(String server, String user, String passphrase, File sshPemFile, String pemPassphrase, String command) throws IOException {
        Connection newConn;
        block2: {
            this.user = null;
            this.s_out = null;
            this.s_err = null;
            this.kill = false;
            this.command = null;
            this.lock = new Object();
            newConn = new Connection(server);
            newConn.connect();
            try {
                newConn.authenticateWithPublicKey(user, sshPemFile, pemPassphrase);
            }
            catch (IOException e) {
                newConn = new Connection(server);
                newConn.connect();
                if (newConn.authenticateWithPassword(user, passphrase)) break block2;
                throw new RuntimeException("Could not log in to " + newConn.getHostname() + " with the given credentials (" + user + ").");
            }
        }
        this.connection = newConn;
        this.user = user;
        this.command = command;
    }

    public SSHCommandRunner(String server, String user, String password, String command) throws IOException {
        Connection newConn;
        block2: {
            this.user = null;
            this.s_out = null;
            this.s_err = null;
            this.kill = false;
            this.command = null;
            this.lock = new Object();
            newConn = new Connection(server);
            newConn.connect();
            try {
                newConn.authenticateWithPassword(user, password);
            }
            catch (IOException e) {
                newConn = new Connection(server);
                newConn.connect();
                if (newConn.authenticateWithPassword(user, password)) break block2;
                throw new RuntimeException("Could not log in to " + newConn.getHostname() + " with the given credentials (" + user + ").");
            }
        }
        this.connection = newConn;
        this.user = user;
        this.command = command;
    }

    public SSHCommandRunner(String server, String user, String sshPemFile, String passphrase, String command) throws IOException {
        this(server, user, new File(sshPemFile), passphrase, command);
    }

    public SSHCommandRunner(String server, String user, String passphrase, String sshPemFile, String pemPassphrase, String command) throws IOException {
        this(server, user, passphrase, new File(sshPemFile), pemPassphrase, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(LogRecord logRecord) {
        try {
            if (logRecord == null) {
                logRecord = TestRecords.fine();
            }
            Object object = this.lock;
            synchronized (object) {
                String message = "ssh " + this.connection.getHostname() + " " + this.command;
                if (this.user != null) {
                    message = "ssh " + this.user + "@" + this.connection.getHostname() + " " + this.command;
                }
                logRecord.setMessage(message);
                log.log(logRecord);
                this.session = this.connection.openSession();
                this.session.execCommand(this.command);
                this.out = new StreamGobbler(this.session.getStdout());
                this.err = new StreamGobbler(this.session.getStderr());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        this.run(TestRecords.action());
    }

    public Integer waitFor() {
        return this.waitForWithTimeout(null);
    }

    public Integer waitForWithTimeout(Long timeoutMS) {
        int res = 0;
        boolean timedOut = false;
        int cond = 48;
        long startTime = System.currentTimeMillis();
        while (!this.kill && (res & cond) != cond) {
            if (timeoutMS != null && System.currentTimeMillis() - startTime > timeoutMS) {
                timedOut = true;
                break;
            }
            res = this.session.waitForCondition(cond, 1000L);
        }
        Integer exitCode = null;
        if (!this.kill && !timedOut) {
            exitCode = this.getExitCode();
        }
        this.session.close();
        this.kill = false;
        return exitCode;
    }

    public boolean isDone() {
        if (this.session == null) {
            return false;
        }
        return this.getExitCode() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public SSHCommandResult getSSHCommandResult() {
        return new SSHCommandResult(this.getExitCode(), this.getStdout(), this.getStderr());
    }

    public Integer getExitCode() {
        return this.session.getExitStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStdout() {
        Object object = this.lock;
        synchronized (object) {
            if (this.s_out == null) {
                this.s_out = this.convertStreamToString(this.out);
            }
            return this.s_out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStderr() {
        Object object = this.lock;
        synchronized (object) {
            if (this.s_err == null) {
                this.s_err = this.convertStreamToString(this.err);
            }
            return this.s_err;
        }
    }

    public void setCommand(String command) {
        this.reset();
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void runCommand(String command) {
        this.runCommand(command, TestRecords.fine());
    }

    public void runCommand(String command, LogRecord logRecord) {
        this.reset();
        this.command = command;
        this.run(logRecord);
    }

    public SSHCommandResult runCommandAndWait(String command) {
        return this.runCommandAndWait(command, null, TestRecords.fine(), false, true);
    }

    public SSHCommandResult runCommandAndWait(String command, boolean liveLogOutput) {
        return this.runCommandAndWait(command, null, TestRecords.fine(), liveLogOutput, true);
    }

    public SSHCommandResult runCommandAndWait(String command, Long timeoutMS) {
        return this.runCommandAndWait(command, timeoutMS, TestRecords.fine(), false, true);
    }

    public SSHCommandResult runCommandAndWait(String command, LogRecord logRecord) {
        return this.runCommandAndWait(command, null, logRecord, false, true);
    }

    public SSHCommandResult runCommandAndWaitWithoutLogging(String command) {
        return this.runCommandAndWait(command, null, TestRecords.fine(), false, false);
    }

    public SSHCommandResult runCommandAndWait(String command, Long timeoutMS, LogRecord logRecord, boolean liveLogOutput, boolean logOutput) {
        this.runCommand(command, logRecord);
        SplitStreamLogger logger = null;
        if (liveLogOutput && logOutput) {
            logger = new SplitStreamLogger(this);
            logger.log(logRecord.getLevel(), logRecord.getLevel());
        }
        this.waitForWithTimeout(timeoutMS);
        SSHCommandResult sshCommandResult = null;
        if (liveLogOutput && logOutput) {
            this.s_out = logger.getStdout();
            this.s_err = logger.getStderr();
        }
        sshCommandResult = this.getSSHCommandResult();
        if (!liveLogOutput && logOutput) {
            String o = this.getStdout().split("\n").length > 1 ? "\n" : "";
            String e = this.getStderr().split("\n").length > 1 ? "\n" : "";
            log.log(logRecord.getLevel(), "Stdout: " + o + sshCommandResult.getStdout());
            log.log(logRecord.getLevel(), "Stderr: " + e + sshCommandResult.getStderr());
        }
        if (logOutput) {
            log.log(logRecord.getLevel(), "ExitCode: " + sshCommandResult.getExitCode());
        }
        return sshCommandResult;
    }

    public synchronized void kill() {
        this.kill = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getStdoutStream() {
        Object object = this.lock;
        synchronized (object) {
            return this.out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getStdErrStream() {
        Object object = this.lock;
        synchronized (object) {
            return this.err;
        }
    }

    public void reset() {
        try {
            if (this.out != null) {
                this.out.close();
            }
            if (this.err != null) {
                this.err.close();
            }
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (IOException ioe) {
            log.log(Level.FINER, "Couldn't close input stream", ioe);
        }
        this.s_out = null;
        this.s_err = null;
        this.command = null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public static String[] executeViaSSHWithReturn(String hostname, String user, String command) {
        return SSHCommandRunner.executeViaSSHWithReturnWithTimeout(hostname, user, command, null);
    }

    public static String[] executeViaSSHWithReturnWithTimeout(String hostname, String user, String command, Long timeoutMS) {
        SplitStreamLogger logger;
        SSHCommandRunner runner = null;
        try {
            runner = new SSHCommandRunner(hostname, user, new File(System.getProperty("user.dir") + "/.ssh/id_auto_dsa"), System.getProperty("jon.server.sshkey.passphrase"), command);
            runner.run();
            logger = new SplitStreamLogger(runner);
            logger.log();
            Integer exitcode = runner.waitForWithTimeout(timeoutMS);
            if (exitcode == null) {
                log.log(Level.INFO, "SSH command did not complete within timeout window");
                return SSHCommandRunner.failSSH();
            }
        }
        catch (Exception e) {
            log.log(Level.INFO, "SSH command failed:", e);
            return SSHCommandRunner.failSSH();
        }
        return new String[]{logger.getStdout(), logger.getStderr()};
    }

    private static String[] failSSH() {
        return new String[]{"fail", "fail"};
    }

    public static void main(String[] args) throws Exception {
        Logger log = Logger.getLogger(SSHCommandRunner.class.getName());
        SSHCommandRunner scr = new SSHCommandRunner("f14-1.usersys.redhat.com", "root", "dog8code", "sdf", "sdfs", null);
        scr.runCommandAndWait("sleep 5;echo 'hi there';sleep 3", true);
        System.out.println("Result: " + scr.getStdout());
    }
}

